/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.scripts;

import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.aws.kms.crypto.KmsSymmetricEncrypter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class KmsSymmetricJweCompactEncrypterScript {
    private static final String COMMAND = "gradle kmsSymmetricJWSEncrypt";

    public static void main(String[] args) throws Exception {
        new KmsSymmetricJweCompactEncrypterScript().execute(args);
    }

    private void execute(String[] args) throws Exception {
        Options options = this.buildOptions();
        CommandLine cmd = new DefaultParser().parse(options, args);
        if (cmd.hasOption("help")) {
            System.out.println("\n***********************************************\n");
            new HelpFormatter().printHelp(COMMAND, options);
            System.out.println("\n***********************************************\n");
        } else if (!(cmd.hasOption("alg") && cmd.hasOption("enc") && cmd.hasOption("kid") && cmd.hasOption("payload"))) {
            System.out.printf("%1$s%2$s, %3$s, %4$s and %5$s options are required. Use '%6$s' for details of these options.%1$s", "\n***********************************************\n", "alg", "enc", "kid", "payload", "help");
        } else {
            JWEObject jweObject = this.encrypt(JWEAlgorithm.parse((String)cmd.getOptionValue("alg")), EncryptionMethod.parse((String)cmd.getOptionValue("enc")), cmd.getOptionValue("kid"), cmd.getOptionValue("payload"));
            System.out.printf("%1$sJWE Token:%1$s%2$s%1$s", "\n***********************************************\n", jweObject.serialize());
        }
    }

    private Options buildOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt("help").desc("Print this help message.").build());
        options.addOption(Option.builder().hasArg().longOpt("alg").desc("Data-key encryption algorithm").build());
        options.addOption(Option.builder().hasArg().longOpt("enc").desc("Content encryption algorithm/method.").build());
        options.addOption(Option.builder().hasArg().longOpt("kid").desc("Id of the key, which should used for encrypting data-key. Pass a KMS CMK ARN or alias ARN. Note: You'll have to configure credentials of an IAM user in the default profile, who as access to the provided CMK. Follow these instruction to configure user credentials: https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-files.html#cli-configure-files-where").build());
        options.addOption(Option.builder().longOpt("payload").hasArg().desc("Payload to encrypt.").build());
        return options;
    }

    private JWEObject encrypt(JWEAlgorithm alg, EncryptionMethod enc, String kid, String payload) throws Exception {
        KmsSymmetricEncrypter jweEncrypter = new KmsSymmetricEncrypter(AWSKMSClientBuilder.defaultClient(), kid);
        JWEObject jweObject = new JWEObject(new JWEHeader.Builder(alg, enc).keyID(kid).build(), new Payload(payload));
        jweObject.encrypt((JWEEncrypter)jweEncrypter);
        return jweObject;
    }
}

