/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters.ssm;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.lambda.powertools.parameters.BaseProvider;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.ssm.SSMProviderBuilder;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;

public class SSMProvider
extends BaseProvider {
    private final SsmClient client;
    private boolean decrypt = false;
    private boolean recursive = false;

    SSMProvider(CacheManager cacheManager, TransformationManager transformationManager, SsmClient client) {
        super(cacheManager, transformationManager);
        this.client = client;
    }

    public static SSMProviderBuilder builder() {
        return new SSMProviderBuilder();
    }

    public static SSMProvider create() {
        return new SSMProviderBuilder().build();
    }

    public String getValue(String key) {
        GetParameterRequest request = (GetParameterRequest)GetParameterRequest.builder().name(key).withDecryption(Boolean.valueOf(this.decrypt)).build();
        return this.client.getParameter(request).parameter().value();
    }

    public SSMProvider withDecryption() {
        this.decrypt = true;
        return this;
    }

    public SSMProvider recursive() {
        this.recursive = true;
        return this;
    }

    protected Map<String, String> getMultipleValues(String path) {
        return this.getMultipleBis(path, null);
    }

    private Map<String, String> getMultipleBis(String path, String nextToken) {
        GetParametersByPathRequest request = (GetParametersByPathRequest)GetParametersByPathRequest.builder().path(path).withDecryption(Boolean.valueOf(this.decrypt)).recursive(Boolean.valueOf(this.recursive)).nextToken(nextToken).build();
        HashMap<String, String> params = new HashMap<String, String>();
        GetParametersByPathResponse res = this.client.getParametersByPath(request);
        if (res.hasParameters()) {
            res.parameters().forEach(parameter -> {
                String name = parameter.name();
                if (name.startsWith(path)) {
                    name = name.replaceFirst(path, "");
                }
                name = name.replaceFirst("/", "");
                params.put(name, parameter.value());
            });
        }
        if (!StringUtils.isEmpty((CharSequence)res.nextToken())) {
            params.putAll(this.getMultipleBis(path, res.nextToken()));
        }
        return params;
    }

    protected void resetToDefaults() {
        super.resetToDefaults();
        this.recursive = false;
        this.decrypt = false;
    }

    SsmClient getClient() {
        return this.client;
    }
}

