/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters.ssm;

import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.lambda.powertools.common.internal.UserAgentConfigurator;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.ssm.SSMProvider;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;

public class SSMProviderBuilder {
    private SsmClient client;
    private CacheManager cacheManager;
    private TransformationManager transformationManager;

    private static SsmClient createClient() {
        return (SsmClient)((SsmClientBuilder)((SsmClientBuilder)((SsmClientBuilder)SsmClient.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).region(Region.of((String)System.getenv(SdkSystemSetting.AWS_REGION.environmentVariable())))).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)UserAgentConfigurator.getUserAgent((String)"parameters")).build())).build();
    }

    public SSMProvider build() {
        if (this.cacheManager == null) {
            this.cacheManager = new CacheManager();
        }
        if (this.client == null) {
            this.client = SSMProviderBuilder.createClient();
        }
        if (this.transformationManager == null) {
            this.transformationManager = new TransformationManager();
        }
        SSMProvider provider = new SSMProvider(this.cacheManager, this.transformationManager, this.client);
        return provider;
    }

    public SSMProviderBuilder withClient(SsmClient client) {
        this.client = client;
        return this;
    }

    public SSMProviderBuilder withCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    public SSMProviderBuilder withTransformationManager(TransformationManager transformationManager) {
        this.transformationManager = transformationManager;
        return this;
    }
}

