/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.common.internal;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import software.amazon.awssdk.utilslite.SdkInternalThreadLocal;
import software.amazon.lambda.powertools.common.internal.SystemWrapper;

public final class LambdaHandlerProcessor {
    private static String serviceName = LambdaHandlerProcessor.calculateServiceName();
    private static Boolean isColdStart = null;

    private LambdaHandlerProcessor() {
    }

    private static String calculateServiceName() {
        return SystemWrapper.getenv("POWERTOOLS_SERVICE_NAME") != null ? SystemWrapper.getenv("POWERTOOLS_SERVICE_NAME") : "service_undefined";
    }

    public static boolean isHandlerMethod(ProceedingJoinPoint pjp) {
        return LambdaHandlerProcessor.placedOnRequestHandler(pjp) || LambdaHandlerProcessor.placedOnStreamHandler(pjp);
    }

    public static boolean placedOnRequestHandler(ProceedingJoinPoint pjp) {
        return RequestHandler.class.isAssignableFrom(pjp.getSignature().getDeclaringType()) && pjp.getArgs().length == 2 && pjp.getArgs()[1] instanceof Context;
    }

    public static boolean placedOnStreamHandler(ProceedingJoinPoint pjp) {
        return RequestStreamHandler.class.isAssignableFrom(pjp.getSignature().getDeclaringType()) && pjp.getArgs().length == 3 && pjp.getArgs()[0] instanceof InputStream && pjp.getArgs()[1] instanceof OutputStream && pjp.getArgs()[2] instanceof Context;
    }

    public static Context extractContext(ProceedingJoinPoint pjp) {
        if (LambdaHandlerProcessor.placedOnRequestHandler(pjp)) {
            return (Context)pjp.getArgs()[1];
        }
        if (LambdaHandlerProcessor.placedOnStreamHandler(pjp)) {
            return (Context)pjp.getArgs()[2];
        }
        return null;
    }

    public static String serviceName() {
        return serviceName;
    }

    protected static void resetServiceName() {
        serviceName = LambdaHandlerProcessor.calculateServiceName();
    }

    public static boolean isColdStart() {
        return isColdStart == null;
    }

    public static void coldStartDone() {
        isColdStart = false;
    }

    public static boolean isSamLocal() {
        return "true".equals(SystemWrapper.getenv("AWS_SAM_LOCAL"));
    }

    public static Optional<String> getXrayTraceId() {
        String traceId = SdkInternalThreadLocal.get((String)"AWS_LAMBDA_X_TRACE_ID");
        if (traceId == null) {
            traceId = SystemWrapper.getenv("_X_AMZN_TRACE_ID");
        }
        if (traceId == null) {
            traceId = SystemWrapper.getProperty("com.amazonaws.xray.traceHeader");
        }
        if (traceId != null) {
            return Optional.of(traceId.split(";")[0].replace("Root=", ""));
        }
        return Optional.empty();
    }
}

