/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.common.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.common.internal.SystemWrapper;

public class UserAgentConfigurator {
    public static final String NA = "NA";
    public static final String VERSION_KEY = "powertools.version";
    public static final String PT_FEATURE_VARIABLE = "${PT_FEATURE}";
    public static final String PT_EXEC_ENV_VARIABLE = "${PT_EXEC_ENV}";
    public static final String VERSION_PROPERTIES_FILENAME = "version.properties";
    public static final String AWS_EXECUTION_ENV = "AWS_EXECUTION_ENV";
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentConfigurator.class);
    private static final String NO_OP = "no-op";
    private static final String POWERTOOLS_VERSION = UserAgentConfigurator.getProjectVersion();
    private static final String USER_AGENT_PATTERN = "PT/${PT_FEATURE}/" + POWERTOOLS_VERSION + " PTEnv/" + "${PT_EXEC_ENV}";

    private UserAgentConfigurator() {
        throw new IllegalStateException("Utility class. Not meant to be instantiated");
    }

    static String getProjectVersion() {
        return UserAgentConfigurator.getVersionFromProperties(VERSION_PROPERTIES_FILENAME, VERSION_KEY);
    }

    static String getVersionFromProperties(String propertyFileName, String versionKey) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFileName);
        if (is != null) {
            try {
                Properties properties = new Properties();
                properties.load(is);
                String version = properties.getProperty(versionKey);
                if (version != null && !version.isEmpty()) {
                    return version;
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to read {} file. Using default version.", (Object)propertyFileName);
                LOG.debug("Exception:", (Throwable)e);
            }
        }
        return NA;
    }

    public static String getUserAgent(String ptFeature) {
        String awsExecutionEnv = SystemWrapper.getenv(AWS_EXECUTION_ENV);
        String ptExecEnv = awsExecutionEnv != null ? awsExecutionEnv : NA;
        String userAgent = USER_AGENT_PATTERN.replace(PT_EXEC_ENV_VARIABLE, ptExecEnv);
        if (ptFeature == null || ptFeature.isEmpty()) {
            ptFeature = NO_OP;
        }
        return userAgent.replace(PT_FEATURE_VARIABLE, ptFeature).replace(PT_EXEC_ENV_VARIABLE, ptExecEnv);
    }
}

