/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.internal;

import java.net.URI;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.WebIdentityTokenCredentialsProviderFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.internal.WebIdentityTokenCredentialProperties;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.Region;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.internal.AssumeRoleWithWebIdentityRequestSupplier;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkProtectedApi
public final class StsWebIdentityCredentialsProviderFactory
implements WebIdentityTokenCredentialsProviderFactory {
    @Override
    public AwsCredentialsProvider create(WebIdentityTokenCredentialProperties credentialProperties) {
        return new StsWebIdentityCredentialsProvider(credentialProperties);
    }

    private static final class StsWebIdentityCredentialsProvider
    implements AwsCredentialsProvider,
    SdkAutoCloseable {
        private final StsClient stsClient;
        private final StsAssumeRoleWithWebIdentityCredentialsProvider credentialsProvider;

        private StsWebIdentityCredentialsProvider(WebIdentityTokenCredentialProperties credentialProperties) {
            String roleSessionName = credentialProperties.roleSessionName();
            String sessionName = roleSessionName != null ? roleSessionName : "aws-sdk-java-" + System.currentTimeMillis();
            OrRetryCondition retryCondition = OrRetryCondition.create(context -> context.exception() instanceof IdpCommunicationErrorException, RetryCondition.defaultRetryCondition());
            this.stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().applyMutation(this::configureEndpoint).credentialsProvider(AnonymousCredentialsProvider.create())).overrideConfiguration(o -> o.retryPolicy(r -> r.retryCondition(retryCondition)))).build();
            AssumeRoleWithWebIdentityRequest request = (AssumeRoleWithWebIdentityRequest)AssumeRoleWithWebIdentityRequest.builder().roleArn(credentialProperties.roleArn()).roleSessionName(sessionName).build();
            AssumeRoleWithWebIdentityRequestSupplier supplier = AssumeRoleWithWebIdentityRequestSupplier.builder().assumeRoleWithWebIdentityRequest(request).webIdentityTokenFile(credentialProperties.webIdentityTokenFile()).build();
            this.credentialsProvider = ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().stsClient(this.stsClient)).refreshRequest(supplier).build();
        }

        @Override
        public AwsCredentials resolveCredentials() {
            return this.credentialsProvider.resolveCredentials();
        }

        @Override
        public void close() {
            IoUtils.closeQuietly(this.credentialsProvider, null);
            IoUtils.closeQuietly(this.stsClient, null);
        }

        private void configureEndpoint(StsClientBuilder stsClientBuilder) {
            Region stsRegion;
            try {
                stsRegion = new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (RuntimeException e) {
                stsRegion = null;
            }
            if (stsRegion != null) {
                stsClientBuilder.region(stsRegion);
            } else {
                stsClientBuilder.region(Region.US_EAST_1);
                stsClientBuilder.endpointOverride(URI.create("https://sts.amazonaws.com"));
            }
        }
    }
}

