/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.auth;

import java.util.Date;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.Credentials;

@SdkInternalApi
@ThreadSafe
final class SessionCredentialsHolder {
    private final AwsSessionCredentials sessionCredentials;
    private final Date sessionCredentialsExpiration;

    SessionCredentialsHolder(Credentials credentials) {
        this.sessionCredentials = AwsSessionCredentials.create(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken());
        this.sessionCredentialsExpiration = Date.from(credentials.expiration());
    }

    public AwsSessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }

    public Date getSessionCredentialsExpiration() {
        return this.sessionCredentialsExpiration;
    }
}

