/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts;

import java.util.Collections;
import java.util.List;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.ExpiredTokenException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetAccessKeyInfoResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.IdpRejectedClaimException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.InvalidAuthorizationMessageException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.InvalidIdentityTokenException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.RegionDisabledException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.StsException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.transform.AssumeRoleRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.transform.AssumeRoleWithSamlRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.transform.GetAccessKeyInfoRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.transform.GetCallerIdentityRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.transform.GetFederationTokenRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.transform.GetSessionTokenRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultStsClient
implements StsClient {
    private static final Logger log = Logger.loggerFor(DefaultStsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultStsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    @Override
    public final String serviceName() {
        return "sts";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssumeRoleResponse assumeRole(AssumeRoleRequest assumeRoleRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, ExpiredTokenException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultStsClient.resolveMetricPublishers(this.clientConfiguration, assumeRoleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRole");
            AssumeRoleResponse assumeRoleResponse = (AssumeRoleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRole").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(assumeRoleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new AssumeRoleRequestMarshaller(this.protocolFactory)));
            return assumeRoleResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssumeRoleWithSamlResponse assumeRoleWithSAML(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IdpRejectedClaimException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleWithSamlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultStsClient.resolveMetricPublishers(this.clientConfiguration, assumeRoleWithSamlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRoleWithSAML");
            AssumeRoleWithSamlResponse assumeRoleWithSamlResponse = (AssumeRoleWithSamlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleWithSAML").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(assumeRoleWithSamlRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new AssumeRoleWithSamlRequestMarshaller(this.protocolFactory)));
            return assumeRoleWithSamlResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssumeRoleWithWebIdentityResponse assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IdpRejectedClaimException, IdpCommunicationErrorException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleWithWebIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultStsClient.resolveMetricPublishers(this.clientConfiguration, assumeRoleWithWebIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRoleWithWebIdentity");
            AssumeRoleWithWebIdentityResponse assumeRoleWithWebIdentityResponse = (AssumeRoleWithWebIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleWithWebIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(assumeRoleWithWebIdentityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new AssumeRoleWithWebIdentityRequestMarshaller(this.protocolFactory)));
            return assumeRoleWithWebIdentityResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecodeAuthorizationMessageResponse decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) throws InvalidAuthorizationMessageException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DecodeAuthorizationMessageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultStsClient.resolveMetricPublishers(this.clientConfiguration, decodeAuthorizationMessageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecodeAuthorizationMessage");
            DecodeAuthorizationMessageResponse decodeAuthorizationMessageResponse = (DecodeAuthorizationMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecodeAuthorizationMessage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(decodeAuthorizationMessageRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DecodeAuthorizationMessageRequestMarshaller(this.protocolFactory)));
            return decodeAuthorizationMessageResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessKeyInfoResponse getAccessKeyInfo(GetAccessKeyInfoRequest getAccessKeyInfoRequest) throws AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetAccessKeyInfoResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultStsClient.resolveMetricPublishers(this.clientConfiguration, getAccessKeyInfoRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessKeyInfo");
            GetAccessKeyInfoResponse getAccessKeyInfoResponse = (GetAccessKeyInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessKeyInfo").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getAccessKeyInfoRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetAccessKeyInfoRequestMarshaller(this.protocolFactory)));
            return getAccessKeyInfoResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCallerIdentityResponse getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) throws AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCallerIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultStsClient.resolveMetricPublishers(this.clientConfiguration, getCallerIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCallerIdentity");
            GetCallerIdentityResponse getCallerIdentityResponse = (GetCallerIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCallerIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getCallerIdentityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetCallerIdentityRequestMarshaller(this.protocolFactory)));
            return getCallerIdentityResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetFederationTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultStsClient.resolveMetricPublishers(this.clientConfiguration, getFederationTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFederationToken");
            GetFederationTokenResponse getFederationTokenResponse = (GetFederationTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFederationToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getFederationTokenRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetFederationTokenRequestMarshaller(this.protocolFactory)));
            return getFederationTokenResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSessionTokenResponse getSessionToken(GetSessionTokenRequest getSessionTokenRequest) throws RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSessionTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultStsClient.resolveMetricPublishers(this.clientConfiguration, getSessionTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionToken");
            GetSessionTokenResponse getSessionTokenResponse = (GetSessionTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSessionToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getSessionTokenRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetSessionTokenRequestMarshaller(this.protocolFactory)));
            return getSessionTokenResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return ((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAuthorizationMessageException").exceptionBuilderSupplier(InvalidAuthorizationMessageException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredTokenException").exceptionBuilderSupplier(ExpiredTokenException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("PackedPolicyTooLarge").exceptionBuilderSupplier(PackedPolicyTooLargeException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("RegionDisabledException").exceptionBuilderSupplier(RegionDisabledException::builder).httpStatusCode(403).build())).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedPolicyDocument").exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("IDPRejectedClaim").exceptionBuilderSupplier(IdpRejectedClaimException::builder).httpStatusCode(403).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIdentityToken").exceptionBuilderSupplier(InvalidIdentityTokenException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("IDPCommunicationError").exceptionBuilderSupplier(IdpCommunicationErrorException::builder).httpStatusCode(400).build())).clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(StsException::builder)).build();
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

