/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts;

import java.util.Collections;
import java.util.List;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.StsBaseClientBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultStsBaseClientBuilder<B extends StsBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultStsBaseClientBuilder() {
    }

    @Override
    protected final String serviceEndpointPrefix() {
        return "sts";
    }

    @Override
    protected final String serviceName() {
        return "Sts";
    }

    @Override
    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option(SdkAdvancedClientOption.SIGNER, this.defaultSigner()).option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, false));
    }

    @Override
    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List<ExecutionInterceptor> interceptors = interceptorFactory.getInterceptors("software/amazon/kinesis/shaded/software/amazon/awssdk/services/sts/execution.interceptors");
        interceptors = CollectionUtils.mergeLists(interceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        List<QueryParametersToBodyInterceptor> protocolInterceptors = Collections.singletonList(new QueryParametersToBodyInterceptor());
        interceptors = CollectionUtils.mergeLists(interceptors, protocolInterceptors);
        return config.toBuilder().option(SdkClientOption.EXECUTION_INTERCEPTORS, interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    @Override
    protected final String signingName() {
        return "sts";
    }
}

