/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.ApiName;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.waiters.KinesisAsyncWaiter;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.waiters.internal.WaitersRuntime;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.AttributeMap;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultKinesisAsyncWaiter
implements KinesisAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute<SdkAutoCloseable>(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute<ScheduledExecutorService>(ScheduledExecutorService.class);
    private final KinesisAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeStreamResponse> streamExistsWaiter;
    private final AsyncWaiter<DescribeStreamResponse> streamNotExistsWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultKinesisAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (KinesisAsyncClient)KinesisAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.streamExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStreamResponse.class).acceptors(DefaultKinesisAsyncWaiter.streamExistsWaiterAcceptors())).overrideConfiguration(DefaultKinesisAsyncWaiter.streamExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamNotExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStreamResponse.class).acceptors(DefaultKinesisAsyncWaiter.streamNotExistsWaiterAcceptors())).overrideConfiguration(DefaultKinesisAsyncWaiter.streamNotExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStreamResponse>> waitUntilStreamExists(DescribeStreamRequest describeStreamRequest) {
        return this.streamExistsWaiter.runAsync(() -> this.client.describeStream(this.applyWaitersUserAgent(describeStreamRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStreamResponse>> waitUntilStreamExists(DescribeStreamRequest describeStreamRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamExistsWaiter.runAsync(() -> this.client.describeStream(this.applyWaitersUserAgent(describeStreamRequest)), DefaultKinesisAsyncWaiter.streamExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStreamResponse>> waitUntilStreamNotExists(DescribeStreamRequest describeStreamRequest) {
        return this.streamNotExistsWaiter.runAsync(() -> this.client.describeStream(this.applyWaitersUserAgent(describeStreamRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStreamResponse>> waitUntilStreamNotExists(DescribeStreamRequest describeStreamRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamNotExistsWaiter.runAsync(() -> this.client.describeStream(this.applyWaitersUserAgent(describeStreamRequest)), DefaultKinesisAsyncWaiter.streamNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeStreamResponse>> streamExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStreamResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStreamResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("StreamDescription").field("StreamStatus").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStreamResponse>> streamNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStreamResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStreamResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultKinesisAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration streamExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(18);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create(Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(18);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create(Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    @Override
    public void close() {
        this.managedResources.close();
    }

    public static KinesisAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends KinesisRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build());
        return (T)((KinesisRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build());
    }

    public static final class DefaultBuilder
    implements KinesisAsyncWaiter.Builder {
        private KinesisAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public KinesisAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public KinesisAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public KinesisAsyncWaiter.Builder client(KinesisAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public KinesisAsyncWaiter build() {
            return new DefaultKinesisAsyncWaiter(this);
        }
    }
}

