/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.Tag;

final class TagListCopier {
    TagListCopier() {
    }

    static List<Tag> copy(Collection<? extends Tag> tagListParam) {
        List<Tag> list;
        if (tagListParam == null || tagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            tagListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Tag> copyFromBuilder(Collection<? extends Tag.Builder> tagListParam) {
        List<Tag> list;
        if (tagListParam == null || tagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            tagListParam.forEach(entry -> {
                Tag member = entry == null ? null : (Tag)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Tag.Builder> copyToBuilder(Collection<? extends Tag> tagListParam) {
        List<Tag.Builder> list;
        if (tagListParam == null || tagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            tagListParam.forEach(entry -> {
                Tag.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

