/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, PutRecordResponse> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ShardId").getter(PutRecordResponse.getter(PutRecordResponse::shardId)).setter(PutRecordResponse.setter(Builder::shardId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();
    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("SequenceNumber").getter(PutRecordResponse.getter(PutRecordResponse::sequenceNumber)).setter(PutRecordResponse.setter(Builder::sequenceNumber)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("EncryptionType").getter(PutRecordResponse.getter(PutRecordResponse::encryptionTypeAsString)).setter(PutRecordResponse.setter(Builder::encryptionType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD, SEQUENCE_NUMBER_FIELD, ENCRYPTION_TYPE_FIELD));
    private final String shardId;
    private final String sequenceNumber;
    private final String encryptionType;

    private PutRecordResponse(BuilderImpl builder) {
        super(builder);
        this.shardId = builder.shardId;
        this.sequenceNumber = builder.sequenceNumber;
        this.encryptionType = builder.encryptionType;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final String sequenceNumber() {
        return this.sequenceNumber;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordResponse)) {
            return false;
        }
        PutRecordResponse other = (PutRecordResponse)obj;
        return Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString());
    }

    public final String toString() {
        return ToString.builder("PutRecordResponse").add("ShardId", this.shardId()).add("SequenceNumber", this.sequenceNumber()).add("EncryptionType", this.encryptionTypeAsString()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordResponse, T> g) {
        return obj -> g.apply((PutRecordResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private String shardId;
        private String sequenceNumber;
        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordResponse model) {
            super(model);
            this.shardId(model.shardId);
            this.sequenceNumber(model.sequenceNumber);
            this.encryptionType(model.encryptionType);
        }

        public final String getShardId() {
            return this.shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Override
        public PutRecordResponse build() {
            return new PutRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordResponse> {
        public Builder shardId(String var1);

        public Builder sequenceNumber(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);
    }
}

