/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnhancedMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnhancedMetrics> {
    private static final SdkField<List<String>> SHARD_LEVEL_METRICS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("ShardLevelMetrics").getter(EnhancedMetrics.getter(EnhancedMetrics::shardLevelMetricsAsStrings)).setter(EnhancedMetrics.setter(Builder::shardLevelMetricsWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardLevelMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_LEVEL_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> shardLevelMetrics;

    private EnhancedMetrics(BuilderImpl builder) {
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    public final List<MetricsName> shardLevelMetrics() {
        return MetricsNameListCopier.copyStringToEnum(this.shardLevelMetrics);
    }

    public final boolean hasShardLevelMetrics() {
        return this.shardLevelMetrics != null && !(this.shardLevelMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> shardLevelMetricsAsStrings() {
        return this.shardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShardLevelMetrics() ? this.shardLevelMetricsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedMetrics)) {
            return false;
        }
        EnhancedMetrics other = (EnhancedMetrics)obj;
        return this.hasShardLevelMetrics() == other.hasShardLevelMetrics() && Objects.equals(this.shardLevelMetricsAsStrings(), other.shardLevelMetricsAsStrings());
    }

    public final String toString() {
        return ToString.builder("EnhancedMetrics").add("ShardLevelMetrics", this.hasShardLevelMetrics() ? this.shardLevelMetricsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardLevelMetrics": {
                return Optional.ofNullable(clazz.cast(this.shardLevelMetricsAsStrings()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnhancedMetrics, T> g) {
        return obj -> g.apply((EnhancedMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> shardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedMetrics model) {
            this.shardLevelMetricsWithStrings(model.shardLevelMetrics);
        }

        public final Collection<String> getShardLevelMetrics() {
            if (this.shardLevelMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.shardLevelMetrics;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        @Override
        public final Builder shardLevelMetricsWithStrings(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetricsWithStrings(String ... shardLevelMetrics) {
            this.shardLevelMetricsWithStrings(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<MetricsName> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copyEnumToString(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(MetricsName ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        public EnhancedMetrics build() {
            return new EnhancedMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnhancedMetrics> {
        public Builder shardLevelMetricsWithStrings(Collection<String> var1);

        public Builder shardLevelMetricsWithStrings(String ... var1);

        public Builder shardLevelMetrics(Collection<MetricsName> var1);

        public Builder shardLevelMetrics(MetricsName ... var1);
    }
}

