/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableEnhancedMonitoringResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, DisableEnhancedMonitoringResponse> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(DisableEnhancedMonitoringResponse.getter(DisableEnhancedMonitoringResponse::streamName)).setter(DisableEnhancedMonitoringResponse.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<List<String>> CURRENT_SHARD_LEVEL_METRICS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("CurrentShardLevelMetrics").getter(DisableEnhancedMonitoringResponse.getter(DisableEnhancedMonitoringResponse::currentShardLevelMetricsAsStrings)).setter(DisableEnhancedMonitoringResponse.setter(Builder::currentShardLevelMetricsWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentShardLevelMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<List<String>> DESIRED_SHARD_LEVEL_METRICS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("DesiredShardLevelMetrics").getter(DisableEnhancedMonitoringResponse.getter(DisableEnhancedMonitoringResponse::desiredShardLevelMetricsAsStrings)).setter(DisableEnhancedMonitoringResponse.setter(Builder::desiredShardLevelMetricsWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredShardLevelMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, CURRENT_SHARD_LEVEL_METRICS_FIELD, DESIRED_SHARD_LEVEL_METRICS_FIELD));
    private final String streamName;
    private final List<String> currentShardLevelMetrics;
    private final List<String> desiredShardLevelMetrics;

    private DisableEnhancedMonitoringResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final List<MetricsName> currentShardLevelMetrics() {
        return MetricsNameListCopier.copyStringToEnum(this.currentShardLevelMetrics);
    }

    public final boolean hasCurrentShardLevelMetrics() {
        return this.currentShardLevelMetrics != null && !(this.currentShardLevelMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> currentShardLevelMetricsAsStrings() {
        return this.currentShardLevelMetrics;
    }

    public final List<MetricsName> desiredShardLevelMetrics() {
        return MetricsNameListCopier.copyStringToEnum(this.desiredShardLevelMetrics);
    }

    public final boolean hasDesiredShardLevelMetrics() {
        return this.desiredShardLevelMetrics != null && !(this.desiredShardLevelMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> desiredShardLevelMetricsAsStrings() {
        return this.desiredShardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCurrentShardLevelMetrics() ? this.currentShardLevelMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDesiredShardLevelMetrics() ? this.desiredShardLevelMetricsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableEnhancedMonitoringResponse)) {
            return false;
        }
        DisableEnhancedMonitoringResponse other = (DisableEnhancedMonitoringResponse)obj;
        return Objects.equals(this.streamName(), other.streamName()) && this.hasCurrentShardLevelMetrics() == other.hasCurrentShardLevelMetrics() && Objects.equals(this.currentShardLevelMetricsAsStrings(), other.currentShardLevelMetricsAsStrings()) && this.hasDesiredShardLevelMetrics() == other.hasDesiredShardLevelMetrics() && Objects.equals(this.desiredShardLevelMetricsAsStrings(), other.desiredShardLevelMetricsAsStrings());
    }

    public final String toString() {
        return ToString.builder("DisableEnhancedMonitoringResponse").add("StreamName", this.streamName()).add("CurrentShardLevelMetrics", this.hasCurrentShardLevelMetrics() ? this.currentShardLevelMetricsAsStrings() : null).add("DesiredShardLevelMetrics", this.hasDesiredShardLevelMetrics() ? this.desiredShardLevelMetricsAsStrings() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "CurrentShardLevelMetrics": {
                return Optional.ofNullable(clazz.cast(this.currentShardLevelMetricsAsStrings()));
            }
            case "DesiredShardLevelMetrics": {
                return Optional.ofNullable(clazz.cast(this.desiredShardLevelMetricsAsStrings()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableEnhancedMonitoringResponse, T> g) {
        return obj -> g.apply((DisableEnhancedMonitoringResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> currentShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<String> desiredShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableEnhancedMonitoringResponse model) {
            super(model);
            this.streamName(model.streamName);
            this.currentShardLevelMetricsWithStrings(model.currentShardLevelMetrics);
            this.desiredShardLevelMetricsWithStrings(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Collection<String> getCurrentShardLevelMetrics() {
            if (this.currentShardLevelMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.currentShardLevelMetrics;
        }

        public final void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        @Override
        public final Builder currentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetricsWithStrings(String ... currentShardLevelMetrics) {
            this.currentShardLevelMetricsWithStrings(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<MetricsName> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copyEnumToString(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(MetricsName ... currentShardLevelMetrics) {
            this.currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        public final Collection<String> getDesiredShardLevelMetrics() {
            if (this.desiredShardLevelMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.desiredShardLevelMetrics;
        }

        public final void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @Override
        public final Builder desiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetricsWithStrings(String ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetricsWithStrings(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<MetricsName> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copyEnumToString(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(MetricsName ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        @Override
        public DisableEnhancedMonitoringResponse build() {
            return new DisableEnhancedMonitoringResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableEnhancedMonitoringResponse> {
        public Builder streamName(String var1);

        public Builder currentShardLevelMetricsWithStrings(Collection<String> var1);

        public Builder currentShardLevelMetricsWithStrings(String ... var1);

        public Builder currentShardLevelMetrics(Collection<MetricsName> var1);

        public Builder currentShardLevelMetrics(MetricsName ... var1);

        public Builder desiredShardLevelMetricsWithStrings(Collection<String> var1);

        public Builder desiredShardLevelMetricsWithStrings(String ... var1);

        public Builder desiredShardLevelMetrics(Collection<MetricsName> var1);

        public Builder desiredShardLevelMetrics(MetricsName ... var1);
    }
}

