/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis;

import java.util.List;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.Protocol;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisBaseClientBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisRetryPolicy;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.internal.KinesisHttpConfigurationOptions;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.AttributeMap;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultKinesisBaseClientBuilder<B extends KinesisBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultKinesisBaseClientBuilder() {
    }

    @Override
    protected final String serviceEndpointPrefix() {
        return "kinesis";
    }

    @Override
    protected final String serviceName() {
        return "Kinesis";
    }

    @Override
    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option(SdkAdvancedClientOption.SIGNER, this.defaultSigner()).option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, false));
    }

    @Override
    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List<ExecutionInterceptor> interceptors = interceptorFactory.getInterceptors("software/amazon/kinesis/shaded/software/amazon/awssdk/services/kinesis/execution.interceptors");
        interceptors = CollectionUtils.mergeLists(interceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        return config.toBuilder().option(SdkClientOption.EXECUTION_INTERCEPTORS, interceptors).option(SdkClientOption.RETRY_POLICY, KinesisRetryPolicy.resolveRetryPolicy(config)).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    @Override
    protected final String signingName() {
        return "kinesis";
    }

    @Override
    protected final AttributeMap serviceHttpConfig() {
        AttributeMap result = KinesisHttpConfigurationOptions.defaultHttpConfig();
        return result.merge(AttributeMap.builder().put(SdkHttpConfigurationOption.PROTOCOL, Protocol.HTTP2).build());
    }
}

