/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.eventstream.EventStreamAsyncResponseTransformer;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.eventstream.EventStreamTaggedUnionPojoSupplier;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.ApiName;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkPojoBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.handler.AttachHttpMetadataResponseHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.VoidSdkResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.cbor.AwsCborProtocolFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ExpiredNextTokenException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.InternalFailureException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.InvalidArgumentException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsAccessDeniedException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsDisabledException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsInvalidStateException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsNotFoundException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsOptInRequiredException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsThrottlingException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ResourceInUseException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardEventStream;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponseHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateStreamModeResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ValidationException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersPublisher;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.AddTagsToStreamRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.CreateStreamRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DecreaseStreamRetentionPeriodRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DeleteStreamRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DeregisterStreamConsumerRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeLimitsRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamConsumerRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamSummaryRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DisableEnhancedMonitoringRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.EnableEnhancedMonitoringRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.GetRecordsRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.GetShardIteratorRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.IncreaseStreamRetentionPeriodRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListShardsRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListStreamConsumersRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListStreamsRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListTagsForStreamRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.MergeShardsRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.PutRecordRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.PutRecordsRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.RegisterStreamConsumerRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.RemoveTagsFromStreamRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.SplitShardRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.StartStreamEncryptionRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.StopStreamEncryptionRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.SubscribeToShardRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.UpdateShardCountRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.UpdateStreamModeRequestMarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.waiters.KinesisAsyncWaiter;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
final class DefaultKinesisAsyncClient
implements KinesisAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKinesisAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsCborProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final Executor executor;
    private final AwsJsonProtocolFactory jsonProtocolFactory;
    private final ScheduledExecutorService executorService;

    protected DefaultKinesisAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsCborProtocolFactory.builder()).build();
        this.jsonProtocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executor = clientConfiguration.option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR);
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public final String serviceName() {
        return "kinesis";
    }

    @Override
    public CompletableFuture<AddTagsToStreamResponse> addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, addTagsToStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<AddTagsToStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToStream").withMarshaller(new AddTagsToStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(addTagsToStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest createStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, createStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<CreateStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStream").withMarshaller(new CreateStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(createStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DecreaseStreamRetentionPeriodResponse> decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, decreaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecreaseStreamRetentionPeriod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecreaseStreamRetentionPeriodResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DecreaseStreamRetentionPeriodResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecreaseStreamRetentionPeriod").withMarshaller(new DecreaseStreamRetentionPeriodRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(decreaseStreamRetentionPeriodRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest deleteStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DeleteStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStream").withMarshaller(new DeleteStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(deleteStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeregisterStreamConsumerResponse> deregisterStreamConsumer(DeregisterStreamConsumerRequest deregisterStreamConsumerRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, deregisterStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterStreamConsumer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterStreamConsumerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DeregisterStreamConsumerResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterStreamConsumer").withMarshaller(new DeregisterStreamConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(deregisterStreamConsumerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeLimitsResponse> describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeLimitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLimitsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DescribeLimitsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLimits").withMarshaller(new DescribeLimitsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(describeLimitsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeStreamResponse> describeStream(DescribeStreamRequest describeStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DescribeStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStream").withMarshaller(new DescribeStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(describeStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeStreamConsumerResponse> describeStreamConsumer(DescribeStreamConsumerRequest describeStreamConsumerRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStreamConsumer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamConsumerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DescribeStreamConsumerResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamConsumer").withMarshaller(new DescribeStreamConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(describeStreamConsumerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeStreamSummaryResponse> describeStreamSummary(DescribeStreamSummaryRequest describeStreamSummaryRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeStreamSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStreamSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamSummaryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DescribeStreamSummaryResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamSummary").withMarshaller(new DescribeStreamSummaryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(describeStreamSummaryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DisableEnhancedMonitoringResponse> disableEnhancedMonitoring(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableEnhancedMonitoringRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableEnhancedMonitoring");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableEnhancedMonitoringResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<DisableEnhancedMonitoringResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableEnhancedMonitoring").withMarshaller(new DisableEnhancedMonitoringRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(disableEnhancedMonitoringRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<EnableEnhancedMonitoringResponse> enableEnhancedMonitoring(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableEnhancedMonitoringRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableEnhancedMonitoring");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableEnhancedMonitoringResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<EnableEnhancedMonitoringResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableEnhancedMonitoring").withMarshaller(new EnableEnhancedMonitoringRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(enableEnhancedMonitoringRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetRecordsResponse> getRecords(GetRecordsRequest getRecordsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRecordsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecordsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<GetRecordsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecords").withMarshaller(new GetRecordsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(getRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, getShardIteratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetShardIterator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetShardIteratorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<GetShardIteratorResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetShardIterator").withMarshaller(new GetShardIteratorRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(getShardIteratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<IncreaseStreamRetentionPeriodResponse> increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, increaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IncreaseStreamRetentionPeriod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IncreaseStreamRetentionPeriodResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<IncreaseStreamRetentionPeriodResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("IncreaseStreamRetentionPeriod").withMarshaller(new IncreaseStreamRetentionPeriodRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(increaseStreamRetentionPeriodRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListShardsResponse> listShards(ListShardsRequest listShardsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, listShardsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListShards");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListShardsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<ListShardsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListShards").withMarshaller(new ListShardsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(listShardsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListStreamConsumersResponse> listStreamConsumers(ListStreamConsumersRequest listStreamConsumersRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStreamConsumersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamConsumers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamConsumersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<ListStreamConsumersResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamConsumers").withMarshaller(new ListStreamConsumersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(listStreamConsumersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public ListStreamConsumersPublisher listStreamConsumersPaginator(ListStreamConsumersRequest listStreamConsumersRequest) {
        return new ListStreamConsumersPublisher(this, this.applyPaginatorUserAgent(listStreamConsumersRequest));
    }

    @Override
    public CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest listStreamsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStreamsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<ListStreamsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreams").withMarshaller(new ListStreamsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(listStreamsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForStreamResponse> listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<ListTagsForStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForStream").withMarshaller(new ListTagsForStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(listTagsForStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<MergeShardsResponse> mergeShards(MergeShardsRequest mergeShardsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, mergeShardsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "MergeShards");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeShardsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<MergeShardsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeShards").withMarshaller(new MergeShardsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(mergeShardsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<PutRecordResponse> putRecord(PutRecordRequest putRecordRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, putRecordRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRecord");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecordResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<PutRecordResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecord").withMarshaller(new PutRecordRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(putRecordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<PutRecordsResponse> putRecords(PutRecordsRequest putRecordsRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, putRecordsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecordsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<PutRecordsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecords").withMarshaller(new PutRecordsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(putRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<RegisterStreamConsumerResponse> registerStreamConsumer(RegisterStreamConsumerRequest registerStreamConsumerRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, registerStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterStreamConsumer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterStreamConsumerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<RegisterStreamConsumerResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterStreamConsumer").withMarshaller(new RegisterStreamConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(registerStreamConsumerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsFromStreamResponse> removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<RemoveTagsFromStreamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromStream").withMarshaller(new RemoveTagsFromStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(removeTagsFromStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<SplitShardResponse> splitShard(SplitShardRequest splitShardRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, splitShardRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SplitShard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SplitShardResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<SplitShardResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SplitShard").withMarshaller(new SplitShardRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(splitShardRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StartStreamEncryptionResponse> startStreamEncryption(StartStreamEncryptionRequest startStreamEncryptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, startStreamEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartStreamEncryption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartStreamEncryptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<StartStreamEncryptionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartStreamEncryption").withMarshaller(new StartStreamEncryptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(startStreamEncryptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StopStreamEncryptionResponse> stopStreamEncryption(StopStreamEncryptionRequest stopStreamEncryptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopStreamEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopStreamEncryption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopStreamEncryptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<StopStreamEncryptionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopStreamEncryption").withMarshaller(new StopStreamEncryptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(stopStreamEncryptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<Void> subscribeToShard(SubscribeToShardRequest subscribeToShardRequest, SubscribeToShardResponseHandler asyncResponseHandler) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, subscribeToShardRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SubscribeToShard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            AttachHttpMetadataResponseHandler responseHandler = new AttachHttpMetadataResponseHandler(this.jsonProtocolFactory.createResponseHandler(operationMetadata, SubscribeToShardResponse::builder));
            HttpResponseHandler voidResponseHandler = this.jsonProtocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(false).hasStreamingSuccessResponse(true).build(), VoidSdkResponse::builder);
            HttpResponseHandler eventResponseHandler = this.jsonProtocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(true).hasStreamingSuccessResponse(false).build(), EventStreamTaggedUnionPojoSupplier.builder().putSdkPojoSupplier("SubscribeToShardEvent", SubscribeToShardEventStream::subscribeToShardEventBuilder).defaultSdkPojoSupplier(() -> new SdkPojoBuilder<SubscribeToShardEventStream>(SubscribeToShardEventStream.UNKNOWN)).build());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.jsonProtocolFactory, operationMetadata);
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            EventStreamAsyncResponseTransformer<SubscribeToShardResponse, SubscribeToShardEventStream> asyncResponseTransformer = EventStreamAsyncResponseTransformer.builder().eventStreamResponseHandler(asyncResponseHandler).eventResponseHandler(eventResponseHandler).initialResponseHandler(responseHandler).exceptionResponseHandler(errorResponseHandler).future(future).executor(this.executor).serviceName(this.serviceName()).build();
            CompletableFuture<Void> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubscribeToShard").withMarshaller(new SubscribeToShardRequestMarshaller(this.jsonProtocolFactory)).withResponseHandler(voidResponseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(subscribeToShardRequest), asyncResponseTransformer);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                if (e != null) {
                    try {
                        asyncResponseHandler.exceptionOccurred((Throwable)e);
                    }
                    finally {
                        future.completeExceptionally((Throwable)e);
                    }
                }
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return CompletableFutureUtils.forwardExceptionTo(future, executeFuture);
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseHandler.exceptionOccurred(t));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateShardCountResponse> updateShardCount(UpdateShardCountRequest updateShardCountRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateShardCountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateShardCount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateShardCountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<UpdateShardCountResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateShardCount").withMarshaller(new UpdateShardCountRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(updateShardCountRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateStreamModeResponse> updateStreamMode(UpdateStreamModeRequest updateStreamModeRequest) {
        List<MetricPublisher> metricPublishers = DefaultKinesisAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateStreamModeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStreamMode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStreamModeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
            CompletableFuture<UpdateStreamModeResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStreamMode").withMarshaller(new UpdateStreamModeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(updateStreamModeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(KinesisException::builder)).protocol(AwsJsonProtocol.AWS_JSON)).protocolVersion("1.1")).registerModeledException(ExceptionMetadata.builder().errorCode("KMSThrottlingException").exceptionBuilderSupplier(KmsThrottlingException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").exceptionBuilderSupplier(KmsInvalidStateException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSNotFoundException").exceptionBuilderSupplier(KmsNotFoundException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").exceptionBuilderSupplier(ExpiredIteratorException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSOptInRequired").exceptionBuilderSupplier(KmsOptInRequiredException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").exceptionBuilderSupplier(ExpiredNextTokenException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").exceptionBuilderSupplier(KmsAccessDeniedException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSDisabledException").exceptionBuilderSupplier(KmsDisabledException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends KinesisRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.247").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build());
        return (T)((KinesisRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public KinesisAsyncWaiter waiter() {
        return KinesisAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }
}

