/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.EndpointTag;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.Region;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.kinesis.shaded.software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class S3ControlServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "s3-control";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ca-central-1"), Region.of("ca-central-1-fips"), Region.of("eu-central-1"), Region.of("eu-north-1"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-1-fips"), Region.of("us-east-2"), Region.of("us-east-2-fips"), Region.of("us-west-1"), Region.of("us-west-1-fips"), Region.of("us-west-2"), Region.of("us-west-2-fips"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("us-gov-east-1"), Region.of("us-gov-east-1-fips"), Region.of("us-gov-west-1"), Region.of("us-gov-west-1-fips")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), "ap-northeast-1").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).tags(EndpointTag.of("dualstack")).build(), "ap-northeast-1").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), "ap-northeast-2").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).tags(EndpointTag.of("dualstack")).build(), "ap-northeast-2").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), "ap-northeast-3").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).tags(EndpointTag.of("dualstack")).build(), "ap-northeast-3").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), "ap-south-1").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).tags(EndpointTag.of("dualstack")).build(), "ap-south-1").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), "ap-southeast-1").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).tags(EndpointTag.of("dualstack")).build(), "ap-southeast-1").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), "ap-southeast-2").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).tags(EndpointTag.of("dualstack")).build(), "ap-southeast-2").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), "ca-central-1").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("fips")).build(), "ca-central-1").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "ca-central-1").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack")).build(), "ca-central-1").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1-fips")).build(), "ca-central-1").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), "eu-central-1").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).tags(EndpointTag.of("dualstack")).build(), "eu-central-1").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), "eu-north-1").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).tags(EndpointTag.of("dualstack")).build(), "eu-north-1").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), "eu-west-1").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).tags(EndpointTag.of("dualstack")).build(), "eu-west-1").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), "eu-west-2").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).tags(EndpointTag.of("dualstack")).build(), "eu-west-2").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), "eu-west-3").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).tags(EndpointTag.of("dualstack")).build(), "eu-west-3").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), "sa-east-1").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).tags(EndpointTag.of("dualstack")).build(), "sa-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-east-1-fips")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), "us-east-2").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-east-2").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), "us-east-2").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack")).build(), "us-east-2").put(ServiceEndpointKey.builder().region(Region.of("us-east-2-fips")).build(), "us-east-2").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), "us-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), "us-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack")).build(), "us-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-west-1-fips")).build(), "us-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), "us-west-2").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-west-2").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), "us-west-2").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack")).build(), "us-west-2").put(ServiceEndpointKey.builder().region(Region.of("us-west-2-fips")).build(), "us-west-2").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), "cn-north-1").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).tags(EndpointTag.of("dualstack")).build(), "cn-north-1").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), "cn-northwest-1").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).tags(EndpointTag.of("dualstack")).build(), "cn-northwest-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), "us-gov-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-gov-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), "us-gov-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack")).build(), "us-gov-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1-fips")).build(), "us-gov-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), "us-gov-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-gov-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), "us-gov-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack")).build(), "us-gov-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1-fips")).build(), "us-gov-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().put(Pair.of("aws", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build()), "amazonaws.com").put(Pair.of("aws", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack")).build()), "amazonaws.com").put(Pair.of("aws-cn", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack")).build()), "amazonaws.com.cn").put(Pair.of("aws-us-gov", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build()), "amazonaws.com").put(Pair.of("aws-us-gov", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack")).build()), "amazonaws.com").build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), "s3-control.ap-northeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.ap-northeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), "s3-control.ap-northeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.ap-northeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), "s3-control.ap-northeast-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.ap-northeast-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), "s3-control.ap-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.ap-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), "s3-control.ap-southeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.ap-southeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), "s3-control.ap-southeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.ap-southeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), "s3-control.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("fips")).build(), "s3-control-fips.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "s3-control-fips.dualstack.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1-fips")).build(), "s3-control-fips.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), "s3-control.eu-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.eu-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), "s3-control.eu-north-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.eu-north-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), "s3-control.eu-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.eu-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), "s3-control.eu-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.eu-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), "s3-control.eu-west-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.eu-west-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), "s3-control.sa-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.sa-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), "s3-control.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "s3-control-fips.dualstack.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), "s3-control-fips.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1-fips")).build(), "s3-control-fips.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), "s3-control.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "s3-control-fips.dualstack.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), "s3-control-fips.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2-fips")).build(), "s3-control-fips.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), "s3-control.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "s3-control-fips.dualstack.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), "s3-control-fips.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1-fips")).build(), "s3-control-fips.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), "s3-control.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "s3-control-fips.dualstack.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), "s3-control-fips.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2-fips")).build(), "s3-control-fips.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), "s3-control.cn-north-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.cn-north-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), "s3-control.cn-northwest-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.cn-northwest-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), "s3-control.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "s3-control-fips.dualstack.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), "s3-control-fips.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1-fips")).build(), "s3-control-fips.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), "s3-control.us-gov-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "s3-control-fips.dualstack.us-gov-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), "s3-control-fips.us-gov-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack")).build(), "s3-control.dualstack.us-gov-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1-fips")).build(), "s3-control-fips.us-gov-west-1.amazonaws.com").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().put(Pair.of("aws", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build()), "{service}-fips.dualstack.{region}.{dnsSuffix}").put(Pair.of("aws", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack")).build()), "{service}.dualstack.{region}.{dnsSuffix}").put(Pair.of("aws-cn", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack")).build()), "{service}.dualstack.{region}.{dnsSuffix}").put(Pair.of("aws-us-gov", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build()), "{service}-fips.dualstack.{region}.{dnsSuffix}").put(Pair.of("aws-us-gov", PartitionEndpointKey.builder().tags(EndpointTag.of("dualstack")).build()), "{service}.dualstack.{region}.{dnsSuffix}").build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

