/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.http.apache.internal.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import software.amazon.kinesis.shaded.org.apache.http.HttpEntity;
import software.amazon.kinesis.shaded.org.apache.http.client.config.RequestConfig;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpDelete;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpGet;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpHead;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpOptions;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpPatch;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpPost;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpPut;
import software.amazon.kinesis.shaded.org.apache.http.client.methods.HttpRequestBase;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.apache.internal.ApacheHttpRequestConfig;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.apache.internal.RepeatableInputStreamRequestEntity;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.apache.internal.utils.ApacheUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.NumericUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.StringUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public class ApacheHttpRequestFactory {
    private static final List<String> IGNORE_HEADERS = Arrays.asList("Content-Length", "Host");

    public HttpRequestBase create(HttpExecuteRequest request, ApacheHttpRequestConfig requestConfig) {
        HttpRequestBase base = this.createApacheRequest(request, this.sanitizeUri(request.httpRequest()));
        this.addHeadersToRequest(base, request.httpRequest());
        this.addRequestConfig(base, request.httpRequest(), requestConfig);
        return base;
    }

    private URI sanitizeUri(SdkHttpRequest request) {
        String path = request.encodedPath();
        if (path.contains("//")) {
            int port = request.port();
            String protocol = request.protocol();
            String newPath = StringUtils.replace(path, "//", "/%2F");
            String encodedQueryString = request.encodedQueryParameters().map(value -> "?" + value).orElse("");
            String portString = SdkHttpUtils.isUsingStandardPort(protocol, port) ? "" : ":" + port;
            return URI.create(protocol + "://" + request.host() + portString + newPath + encodedQueryString);
        }
        return request.getUri();
    }

    private void addRequestConfig(HttpRequestBase base, SdkHttpRequest request, ApacheHttpRequestConfig requestConfig) {
        int connectTimeout = NumericUtils.saturatedCast(requestConfig.connectionTimeout().toMillis());
        int connectAcquireTimeout = NumericUtils.saturatedCast(requestConfig.connectionAcquireTimeout().toMillis());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(connectAcquireTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(NumericUtils.saturatedCast(requestConfig.socketTimeout().toMillis())).setLocalAddress(requestConfig.localAddress());
        ApacheUtils.disableNormalizeUri(requestConfigBuilder);
        if (SdkHttpMethod.PUT == request.method() && requestConfig.expectContinueEnabled()) {
            requestConfigBuilder.setExpectContinueEnabled(true);
        }
        base.setConfig(requestConfigBuilder.build());
    }

    private HttpRequestBase createApacheRequest(HttpExecuteRequest request, URI uri) {
        switch (request.httpRequest().method()) {
            case HEAD: {
                return new HttpHead(uri);
            }
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case PATCH: {
                return this.wrapEntity(request, new HttpPatch(uri));
            }
            case POST: {
                return this.wrapEntity(request, new HttpPost(uri));
            }
            case PUT: {
                return this.wrapEntity(request, new HttpPut(uri));
            }
        }
        throw new RuntimeException("Unknown HTTP method name: " + (Object)((Object)request.httpRequest().method()));
    }

    private HttpRequestBase wrapEntity(HttpExecuteRequest request, HttpEntityEnclosingRequestBase entityEnclosingRequest) {
        if (request.contentStreamProvider().isPresent()) {
            HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
            if (!request.httpRequest().firstMatchingHeader("Content-Length").isPresent()) {
                entity = ApacheUtils.newBufferedHttpEntity(entity);
            }
            entityEnclosingRequest.setEntity(entity);
        }
        return entityEnclosingRequest;
    }

    private void addHeadersToRequest(HttpRequestBase httpRequest, SdkHttpRequest request) {
        httpRequest.addHeader("Host", this.getHostHeaderValue(request));
        request.forEachHeader((name, value) -> {
            if (!IGNORE_HEADERS.contains(name)) {
                for (String headerValue : value) {
                    httpRequest.addHeader((String)name, headerValue);
                }
            }
        });
    }

    private String getHostHeaderValue(SdkHttpRequest request) {
        return !SdkHttpUtils.isUsingStandardPort(request.protocol(), request.port()) ? request.host() + ":" + request.port() : request.host();
    }
}

