/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.util.concurrent.CompletableFuture;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public class AsyncBeforeTransmissionExecutionInterceptorsStage
implements RequestPipeline<CompletableFuture<SdkHttpFullRequest>, CompletableFuture<SdkHttpFullRequest>> {
    @Override
    public CompletableFuture<SdkHttpFullRequest> execute(CompletableFuture<SdkHttpFullRequest> input, RequestExecutionContext context) throws Exception {
        CompletableFuture future = new CompletableFuture();
        input.whenComplete((r, t) -> {
            if (t != null) {
                return;
            }
            try {
                context.interceptorChain().beforeTransmission(context.executionContext().interceptorContext(), context.executionAttributes());
                future.complete(r);
            }
            catch (Throwable interceptorException) {
                future.completeExceptionally(interceptorException);
            }
        });
        return CompletableFutureUtils.forwardExceptionTo(future, input);
    }
}

