/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.Response;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages.utils.RetryableStageHelper;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.util.MetricUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class AsyncApiCallAttemptMetricCollectionStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<Response<OutputT>>> {
    private final RequestPipeline<SdkHttpFullRequest, CompletableFuture<Response<OutputT>>> wrapped;

    public AsyncApiCallAttemptMetricCollectionStage(RequestPipeline<SdkHttpFullRequest, CompletableFuture<Response<OutputT>>> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public CompletableFuture<Response<OutputT>> execute(SdkHttpFullRequest input, RequestExecutionContext context) throws Exception {
        MetricCollector apiCallAttemptMetrics = MetricUtils.createAttemptMetricsCollector(context);
        context.attemptMetricCollector(apiCallAttemptMetrics);
        this.reportBackoffDelay(context);
        CompletableFuture<Response<OutputT>> executeFuture = this.wrapped.execute(input, context);
        CompletionStage metricsCollectedFuture = executeFuture.whenComplete((r, t) -> {
            if (t == null) {
                MetricUtils.collectHttpMetrics(apiCallAttemptMetrics, r.httpResponse());
            }
        });
        CompletableFutureUtils.forwardExceptionTo(metricsCollectedFuture, executeFuture);
        return metricsCollectedFuture;
    }

    private void reportBackoffDelay(RequestExecutionContext context) {
        Duration lastBackoffDelay = context.executionAttributes().getAttribute(RetryableStageHelper.LAST_BACKOFF_DELAY_DURATION);
        if (lastBackoffDelay != null) {
            context.attemptMetricCollector().reportMetric(CoreMetric.BACKOFF_DELAY_DURATION, lastBackoffDelay);
        }
    }
}

