/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.loader;

import java.util.Iterator;
import java.util.Optional;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.loader.SdkHttpServiceProvider;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.loader.SdkServiceLoader;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpService;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpService;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.SystemSetting;

@SdkInternalApi
final class ClasspathSdkHttpServiceProvider<T>
implements SdkHttpServiceProvider<T> {
    private final SdkServiceLoader serviceLoader;
    private final SystemSetting implSystemProperty;
    private final Class<T> serviceClass;

    @SdkTestInternalApi
    ClasspathSdkHttpServiceProvider(SdkServiceLoader serviceLoader, SystemSetting implSystemProperty, Class<T> serviceClass) {
        this.serviceLoader = serviceLoader;
        this.implSystemProperty = implSystemProperty;
        this.serviceClass = serviceClass;
    }

    @Override
    public Optional<T> loadService() {
        Iterator<T> httpServices = this.serviceLoader.loadServices(this.serviceClass);
        if (!httpServices.hasNext()) {
            return Optional.empty();
        }
        T httpService = httpServices.next();
        if (httpServices.hasNext()) {
            throw SdkClientException.builder().message(String.format("Multiple HTTP implementations were found on the classpath. To avoid non-deterministic loading implementations, please explicitly provide an HTTP client via the client builders, set the %s system property with the FQCN of the HTTP service to use as the default, or remove all but one HTTP implementation from the classpath", this.implSystemProperty.property())).build();
        }
        return Optional.of(httpService);
    }

    static SdkHttpServiceProvider<SdkHttpService> syncProvider() {
        return new ClasspathSdkHttpServiceProvider<SdkHttpService>(SdkServiceLoader.INSTANCE, SdkSystemSetting.SYNC_HTTP_SERVICE_IMPL, SdkHttpService.class);
    }

    static SdkHttpServiceProvider<SdkAsyncHttpService> asyncProvider() {
        return new ClasspathSdkHttpServiceProvider<SdkAsyncHttpService>(SdkServiceLoader.INSTANCE, SdkSystemSetting.ASYNC_HTTP_SERVICE_IMPL, SdkAsyncHttpService.class);
    }
}

