/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http;

import java.util.function.Consumer;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkGlobalTime;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.retry.ClockSkewAdjuster;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class HttpClientDependencies
implements SdkAutoCloseable {
    private final ClockSkewAdjuster clockSkewAdjuster;
    private final SdkClientConfiguration clientConfiguration;
    private volatile int timeOffset = SdkGlobalTime.getGlobalTimeOffset();

    private HttpClientDependencies(Builder builder) {
        this.clockSkewAdjuster = builder.clockSkewAdjuster != null ? builder.clockSkewAdjuster : new ClockSkewAdjuster();
        this.clientConfiguration = Validate.paramNotNull(builder.clientConfiguration, "ClientConfiguration");
    }

    public static Builder builder() {
        return new Builder();
    }

    public SdkClientConfiguration clientConfiguration() {
        return this.clientConfiguration;
    }

    public ClockSkewAdjuster clockSkewAdjuster() {
        return this.clockSkewAdjuster;
    }

    public int timeOffset() {
        return this.timeOffset;
    }

    public void updateTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
        SdkGlobalTime.setGlobalTimeOffset(timeOffset);
    }

    @Override
    public void close() {
        this.clientConfiguration.close();
    }

    public static class Builder {
        private ClockSkewAdjuster clockSkewAdjuster;
        private SdkClientConfiguration clientConfiguration;

        private Builder() {
        }

        public Builder clockSkewAdjuster(ClockSkewAdjuster clockSkewAdjuster) {
            this.clockSkewAdjuster = clockSkewAdjuster;
            return this;
        }

        public Builder clientConfiguration(SdkClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public Builder clientConfiguration(Consumer<SdkClientConfiguration.Builder> clientConfiguration) {
            SdkClientConfiguration.Builder c = SdkClientConfiguration.builder();
            clientConfiguration.accept(c);
            this.clientConfiguration(c.build());
            return this;
        }

        public HttpClientDependencies build() {
            return new HttpClientDependencies(this);
        }
    }
}

