/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials;

import java.nio.file.Path;
import java.nio.file.Paths;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.internal.WebIdentityCredentialsUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.internal.WebIdentityTokenCredentialProperties;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.StringUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public class WebIdentityTokenFileCredentialsProvider
implements AwsCredentialsProvider,
ToCopyableBuilder<Builder, WebIdentityTokenFileCredentialsProvider> {
    private final AwsCredentialsProvider credentialsProvider;
    private final RuntimeException loadException;
    private final String roleArn;
    private final String roleSessionName;
    private final Path webIdentityTokenFile;

    private WebIdentityTokenFileCredentialsProvider(BuilderImpl builder) {
        AwsCredentialsProvider credentialsProvider = null;
        RuntimeException loadException = null;
        String roleArn = null;
        String roleSessionName = null;
        Path webIdentityTokenFile = null;
        try {
            webIdentityTokenFile = builder.webIdentityTokenFile != null ? builder.webIdentityTokenFile : Paths.get(StringUtils.trim(SdkSystemSetting.AWS_WEB_IDENTITY_TOKEN_FILE.getStringValueOrThrow()), new String[0]);
            roleArn = builder.roleArn != null ? builder.roleArn : StringUtils.trim(SdkSystemSetting.AWS_ROLE_ARN.getStringValueOrThrow());
            roleSessionName = builder.roleSessionName != null ? builder.roleSessionName : (String)SdkSystemSetting.AWS_ROLE_SESSION_NAME.getStringValue().orElse(null);
            WebIdentityTokenCredentialProperties credentialProperties = WebIdentityTokenCredentialProperties.builder().roleArn(roleArn).roleSessionName(roleSessionName).webIdentityTokenFile(webIdentityTokenFile).build();
            credentialsProvider = WebIdentityCredentialsUtils.factory().create(credentialProperties);
        }
        catch (RuntimeException e) {
            loadException = e;
        }
        this.loadException = loadException;
        this.credentialsProvider = credentialsProvider;
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
        this.webIdentityTokenFile = webIdentityTokenFile;
    }

    public static WebIdentityTokenFileCredentialsProvider create() {
        return WebIdentityTokenFileCredentialsProvider.builder().build();
    }

    @Override
    public AwsCredentials resolveCredentials() {
        if (this.loadException != null) {
            throw this.loadException;
        }
        return this.credentialsProvider.resolveCredentials();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String toString() {
        return ToString.create("WebIdentityTokenCredentialsProvider");
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String roleSessionName;
        private Path webIdentityTokenFile;

        BuilderImpl() {
        }

        private BuilderImpl(WebIdentityTokenFileCredentialsProvider provider) {
            this.roleArn = provider.roleArn;
            this.roleSessionName = provider.roleSessionName;
            this.webIdentityTokenFile = provider.webIdentityTokenFile;
        }

        @Override
        public Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public void setRoleArn(String roleArn) {
            this.roleArn(roleArn);
        }

        @Override
        public Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public void setRoleSessionName(String roleSessionName) {
            this.roleSessionName(roleSessionName);
        }

        @Override
        public Builder webIdentityTokenFile(Path webIdentityTokenFile) {
            this.webIdentityTokenFile = webIdentityTokenFile;
            return this;
        }

        public void setWebIdentityTokenFile(Path webIdentityTokenFile) {
            this.webIdentityTokenFile(webIdentityTokenFile);
        }

        @Override
        public WebIdentityTokenFileCredentialsProvider build() {
            return new WebIdentityTokenFileCredentialsProvider(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebIdentityTokenFileCredentialsProvider> {
        public Builder roleArn(String var1);

        public Builder roleSessionName(String var1);

        public Builder webIdentityTokenFile(Path var1);

        @Override
        public WebIdentityTokenFileCredentialsProvider build();
    }
}

