/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials;

import java.util.Objects;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.Immutable;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@Immutable
@SdkPublicApi
public final class AwsSessionCredentials
implements AwsCredentials {
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;

    private AwsSessionCredentials(String accessKey, String secretKey, String sessionToken) {
        this.accessKeyId = Validate.paramNotNull(accessKey, "accessKey");
        this.secretAccessKey = Validate.paramNotNull(secretKey, "secretKey");
        this.sessionToken = Validate.paramNotNull(sessionToken, "sessionToken");
    }

    public static AwsSessionCredentials create(String accessKey, String secretKey, String sessionToken) {
        return new AwsSessionCredentials(accessKey, secretKey, sessionToken);
    }

    @Override
    public String accessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public String toString() {
        return ToString.builder("AwsSessionCredentials").add("accessKeyId", this.accessKeyId()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsSessionCredentials that = (AwsSessionCredentials)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretAccessKey, that.secretAccessKey) && Objects.equals(this.sessionToken, that.sessionToken);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        return hashCode;
    }
}

