/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.transform;

import software.amazon.kinesis.shaded.com.amazonaws.AmazonServiceException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.ThreadSafe;
import software.amazon.kinesis.shaded.com.amazonaws.transform.AbstractErrorUnmarshaller;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.core.TreeNode;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.JsonNode;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategies;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.node.NullNode;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        if (jsonContent == null || NullNode.instance.equals(jsonContent)) {
            return null;
        }
        return (AmazonServiceException)MAPPER.treeToValue((TreeNode)jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            MAPPER.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        }
        catch (LinkageError e) {
            MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.PASCAL_CASE_TO_CAMEL_CASE);
        }
    }
}

