/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.s3.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.AmazonS3;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.HeadBucketRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.HeadBucketResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.waiters.HeadBucketFunction;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.waiters.HeadObjectFunction;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.HttpFailureStatusAcceptor;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.PollingStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.Waiter;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterState;

public class AmazonS3Waiters {
    private final AmazonS3 client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonS3Waiters(AmazonS3 client) {
        this.client = client;
    }

    public Waiter<HeadBucketRequest> bucketNotExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<HeadBucketRequest> bucketExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(301, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(403, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetObjectMetadataRequest> objectExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetObjectMetadataRequest> objectNotExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

