/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.v1;

import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.services.kms.AWSKMS;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.S3Direct;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.v1.ContentCryptoMaterial;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.v1.S3CryptoModuleAE;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.v1.S3ObjectWrapper;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.CryptoMode;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.EncryptionMaterialsProvider;

class S3CryptoModuleAEStrict
extends S3CryptoModuleAE {
    S3CryptoModuleAEStrict(AWSKMS kms, S3Direct s3, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(kms, s3, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
        if (cryptoConfig.getCryptoMode() != CryptoMode.StrictAuthenticatedEncryption) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected final boolean isStrict() {
        return true;
    }

    @Override
    protected void securityCheck(ContentCryptoMaterial cekMaterial, S3ObjectWrapper retrieved) {
        if (!ContentCryptoScheme.AES_GCM.equals(cekMaterial.getContentCryptoScheme())) {
            throw new SecurityException("S3 object [bucket: " + retrieved.getBucketName() + ", key: " + retrieved.getKey() + "] not encrypted using authenticated encryption");
        }
    }
}

