/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.s3;

import software.amazon.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.NotThreadSafe;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkTestInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.client.AwsSyncClientParams;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkFunction;
import software.amazon.kinesis.shaded.com.amazonaws.regions.AwsRegionProvider;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.AmazonS3;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.AmazonS3Builder;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.AmazonS3ClientParamsWrapper;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.S3CredentialsProviderChain;

@NotThreadSafe
public final class AmazonS3ClientBuilder
extends AmazonS3Builder<AmazonS3ClientBuilder, AmazonS3> {
    private AmazonS3ClientBuilder() {
    }

    @SdkTestInternalApi
    AmazonS3ClientBuilder(SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> clientFactory, ClientConfigurationFactory clientConfigFactory, AwsRegionProvider regionProvider) {
        super(clientFactory, clientConfigFactory, regionProvider);
    }

    public static AmazonS3ClientBuilder standard() {
        return (AmazonS3ClientBuilder)new AmazonS3ClientBuilder().withCredentials(new S3CredentialsProviderChain());
    }

    public static AmazonS3 defaultClient() {
        return (AmazonS3)AmazonS3ClientBuilder.standard().build();
    }

    @Override
    protected AmazonS3 build(AwsSyncClientParams clientParams) {
        return (AmazonS3)this.clientFactory.apply(new AmazonS3ClientParamsWrapper(clientParams, this.resolveS3ClientOptions()));
    }
}

