/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.CopyCommand;

@SdkInternalApi
public class CopyCommandMarshaller {
    private static final MarshallingInfo<String> DATATABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTableName").build();
    private static final MarshallingInfo<String> DATATABLECOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTableColumns").build();
    private static final MarshallingInfo<String> COPYOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyOptions").build();
    private static final CopyCommandMarshaller instance = new CopyCommandMarshaller();

    public static CopyCommandMarshaller getInstance() {
        return instance;
    }

    public void marshall(CopyCommand copyCommand, ProtocolMarshaller protocolMarshaller) {
        if (copyCommand == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(copyCommand.getDataTableName(), DATATABLENAME_BINDING);
            protocolMarshaller.marshall(copyCommand.getDataTableColumns(), DATATABLECOLUMNS_BINDING);
            protocolMarshaller.marshall(copyCommand.getCopyOptions(), COPYOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

