/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.InputUpdate;

@SdkInternalApi
public class InputUpdateMarshaller {
    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputId").build();
    private static final MarshallingInfo<String> NAMEPREFIXUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefixUpdate").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATIONUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputProcessingConfigurationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUTUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsInputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUTUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseInputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMAUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchemaUpdate").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISMUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParallelismUpdate").build();
    private static final InputUpdateMarshaller instance = new InputUpdateMarshaller();

    public static InputUpdateMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputUpdate inputUpdate, ProtocolMarshaller protocolMarshaller) {
        if (inputUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(inputUpdate.getInputId(), INPUTID_BINDING);
            protocolMarshaller.marshall(inputUpdate.getNamePrefixUpdate(), NAMEPREFIXUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.getInputProcessingConfigurationUpdate(), INPUTPROCESSINGCONFIGURATIONUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.getKinesisStreamsInputUpdate(), KINESISSTREAMSINPUTUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.getKinesisFirehoseInputUpdate(), KINESISFIREHOSEINPUTUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.getInputSchemaUpdate(), INPUTSCHEMAUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.getInputParallelismUpdate(), INPUTPARALLELISMUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

