/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonWebServiceResult;
import software.amazon.kinesis.shaded.com.amazonaws.ResponseMetadata;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.ApplicationSummary;

public class ListApplicationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ApplicationSummary> applicationSummaries;
    private Boolean hasMoreApplications;

    public List<ApplicationSummary> getApplicationSummaries() {
        return this.applicationSummaries;
    }

    public void setApplicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
        if (applicationSummaries == null) {
            this.applicationSummaries = null;
            return;
        }
        this.applicationSummaries = new ArrayList<ApplicationSummary>(applicationSummaries);
    }

    public ListApplicationsResult withApplicationSummaries(ApplicationSummary ... applicationSummaries) {
        if (this.applicationSummaries == null) {
            this.setApplicationSummaries(new ArrayList<ApplicationSummary>(applicationSummaries.length));
        }
        for (ApplicationSummary ele : applicationSummaries) {
            this.applicationSummaries.add(ele);
        }
        return this;
    }

    public ListApplicationsResult withApplicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
        this.setApplicationSummaries(applicationSummaries);
        return this;
    }

    public void setHasMoreApplications(Boolean hasMoreApplications) {
        this.hasMoreApplications = hasMoreApplications;
    }

    public Boolean getHasMoreApplications() {
        return this.hasMoreApplications;
    }

    public ListApplicationsResult withHasMoreApplications(Boolean hasMoreApplications) {
        this.setHasMoreApplications(hasMoreApplications);
        return this;
    }

    public Boolean isHasMoreApplications() {
        return this.hasMoreApplications;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationSummaries() != null) {
            sb.append("ApplicationSummaries: ").append(this.getApplicationSummaries()).append(",");
        }
        if (this.getHasMoreApplications() != null) {
            sb.append("HasMoreApplications: ").append(this.getHasMoreApplications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResult)) {
            return false;
        }
        ListApplicationsResult other = (ListApplicationsResult)obj;
        if (other.getApplicationSummaries() == null ^ this.getApplicationSummaries() == null) {
            return false;
        }
        if (other.getApplicationSummaries() != null && !other.getApplicationSummaries().equals(this.getApplicationSummaries())) {
            return false;
        }
        if (other.getHasMoreApplications() == null ^ this.getHasMoreApplications() == null) {
            return false;
        }
        return other.getHasMoreApplications() == null || other.getHasMoreApplications().equals(this.getHasMoreApplications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationSummaries() == null ? 0 : this.getApplicationSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getHasMoreApplications() == null ? 0 : this.getHasMoreApplications().hashCode());
        return hashCode;
    }

    public ListApplicationsResult clone() {
        try {
            return (ListApplicationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

