/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.waiters;

import java.util.concurrent.ExecutorService;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.waiters.DescribeStreamFunction;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.waiters.StreamExists;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.waiters.StreamNotExists;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.PollingStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.Waiter;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterExecutorServiceFactory;

public class AmazonKinesisWaiters {
    private final AmazonKinesis client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonKinesisWaiters");

    @SdkInternalApi
    public AmazonKinesisWaiters(AmazonKinesis client) {
        this.client = client;
    }

    public Waiter<DescribeStreamRequest> streamExists() {
        return new WaiterBuilder<DescribeStreamRequest, DescribeStreamResult>().withSdkFunction(new DescribeStreamFunction(this.client)).withAcceptors(new StreamExists.IsACTIVEMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(18), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStreamRequest> streamNotExists() {
        return new WaiterBuilder<DescribeStreamRequest, DescribeStreamResult>().withSdkFunction(new DescribeStreamFunction(this.client)).withAcceptors(new StreamNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(18), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

