/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.producer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.producer.protobuf.Messages;

public class Metric {
    private final String name;
    private long duration;
    private final Map<String, String> dimensions;
    private final double sum;
    private final double mean;
    private final double sampleCount;
    private final double min;
    private final double max;

    public Map<String, String> getDimensions() {
        return Collections.unmodifiableMap(this.dimensions);
    }

    public double getSum() {
        return this.sum;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSampleCount() {
        return this.sampleCount;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public String getName() {
        return this.name;
    }

    public long getDuration() {
        return this.duration;
    }

    protected Metric(Messages.Metric m) {
        this.name = m.getName();
        this.duration = m.getSeconds();
        this.dimensions = new LinkedHashMap<String, String>();
        for (Messages.Dimension d : m.getDimensionsList()) {
            this.dimensions.put(d.getKey(), d.getValue());
        }
        Messages.Stats s = m.getStats();
        this.max = s.getMax();
        this.mean = s.getMean();
        this.min = s.getMin();
        this.sum = s.getSum();
        this.sampleCount = s.getCount();
    }

    public String toString() {
        return "Metric [name=" + this.name + ", duration=" + this.duration + ", dimensions=" + this.dimensions + ", sum=" + this.sum + ", mean=" + this.mean + ", sampleCount=" + this.sampleCount + ", min=" + this.min + ", max=" + this.max + "]";
    }
}

