/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.multilang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import software.amazon.kinesis.shaded.org.apache.commons.logging.Log;
import software.amazon.kinesis.shaded.org.apache.commons.logging.LogFactory;

abstract class LineReaderTask<T>
implements Callable<T> {
    private static final Log LOG = LogFactory.getLog(LineReaderTask.class);
    private BufferedReader reader;
    private String description;
    private String shardId;

    LineReaderTask() {
    }

    @Override
    public T call() throws Exception {
        String nextLine = null;
        try {
            LOG.info("Starting: " + this.description);
            while ((nextLine = this.reader.readLine()) != null) {
                HandleLineResult<T> result = this.handleLine(nextLine);
                if (!result.hasReturnValue()) continue;
                return result.returnValue();
            }
        }
        catch (IOException e) {
            return this.returnAfterException(e);
        }
        LOG.info("Stopping: " + this.description);
        return this.returnAfterEndOfInput();
    }

    protected abstract HandleLineResult<T> handleLine(String var1);

    protected abstract T returnAfterException(Exception var1) throws Exception;

    protected abstract T returnAfterEndOfInput();

    public String getShardId() {
        return this.shardId;
    }

    public String getDescription() {
        return this.description;
    }

    protected LineReaderTask<T> initialize(InputStream stream, String shardId, String description) {
        return this.initialize(new BufferedReader(new InputStreamReader(stream)), shardId, description);
    }

    protected LineReaderTask<T> initialize(BufferedReader reader, String shardId, String description) {
        this.reader = reader;
        this.shardId = shardId;
        this.description = description;
        return this;
    }

    protected class HandleLineResult<V> {
        private boolean hasReturnValue;
        private V returnValue;

        HandleLineResult() {
            this.hasReturnValue = false;
        }

        HandleLineResult(V returnValue) {
            this.hasReturnValue = true;
            this.returnValue = returnValue;
        }

        boolean hasReturnValue() {
            return this.hasReturnValue;
        }

        V returnValue() {
            if (this.hasReturnValue()) {
                return this.returnValue;
            }
            throw new RuntimeException("There was no value to return.");
        }
    }
}

