/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.transform;

import java.util.Date;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ConsumerDescription;

@SdkInternalApi
public class ConsumerDescriptionMarshaller {
    private static final MarshallingInfo<String> CONSUMERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerName").build();
    private static final MarshallingInfo<String> CONSUMERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerARN").build();
    private static final MarshallingInfo<String> CONSUMERSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerStatus").build();
    private static final MarshallingInfo<Date> CONSUMERCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerCreationTimestamp").timestampFormat("unixTimestampInMillis").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final ConsumerDescriptionMarshaller instance = new ConsumerDescriptionMarshaller();

    public static ConsumerDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConsumerDescription consumerDescription, ProtocolMarshaller protocolMarshaller) {
        if (consumerDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(consumerDescription.getConsumerName(), CONSUMERNAME_BINDING);
            protocolMarshaller.marshall(consumerDescription.getConsumerARN(), CONSUMERARN_BINDING);
            protocolMarshaller.marshall(consumerDescription.getConsumerStatus(), CONSUMERSTATUS_BINDING);
            protocolMarshaller.marshall(consumerDescription.getConsumerCreationTimestamp(), CONSUMERCREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall(consumerDescription.getStreamARN(), STREAMARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

