/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricDatum;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StatisticSet;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.MetricDatumWithKey;

public class MetricAccumulatingQueue<KeyType> {
    private BlockingQueue<MetricDatumWithKey<KeyType>> queue;
    private Map<KeyType, MetricDatum> map;

    public MetricAccumulatingQueue(int maxQueueSize) {
        this.queue = new LinkedBlockingQueue<MetricDatumWithKey<KeyType>>(maxQueueSize);
        this.map = new HashMap<KeyType, MetricDatum>();
    }

    public synchronized List<MetricDatumWithKey<KeyType>> drain(int maxItems) {
        ArrayList<MetricDatumWithKey<KeyType>> drainedItems = new ArrayList<MetricDatumWithKey<KeyType>>(maxItems);
        this.queue.drainTo(drainedItems, maxItems);
        for (MetricDatumWithKey metricDatumWithKey : drainedItems) {
            this.map.remove(metricDatumWithKey.key);
        }
        return drainedItems;
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized int size() {
        return this.queue.size();
    }

    public synchronized boolean offer(KeyType key, MetricDatum datum) {
        MetricDatum old = this.map.get(key);
        if (old == null) {
            boolean offered = this.queue.offer(new MetricDatumWithKey<KeyType>(key, datum));
            if (offered) {
                this.map.put(key, datum);
            }
            return offered;
        }
        this.accumulate(old, datum);
        return true;
    }

    private void accumulate(MetricDatum oldDatum, MetricDatum newDatum) {
        if (!oldDatum.getUnit().equals(newDatum.getUnit())) {
            throw new IllegalArgumentException("Unit mismatch for datum named " + oldDatum.getMetricName());
        }
        StatisticSet oldStats = oldDatum.getStatisticValues();
        StatisticSet newStats = newDatum.getStatisticValues();
        oldStats.setSampleCount(oldStats.getSampleCount() + newStats.getSampleCount());
        oldStats.setMaximum(Math.max(oldStats.getMaximum(), newStats.getMaximum()));
        oldStats.setMinimum(Math.min(oldStats.getMinimum(), newStats.getMinimum()));
        oldStats.setSum(oldStats.getSum() + newStats.getSum());
    }
}

