/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl;

import java.util.ArrayList;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonClientException;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricDatum;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.CWMetricKey;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.CWPublisherRunnable;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.ICWMetricsPublisher;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.MetricDatumWithKey;
import software.amazon.kinesis.shaded.org.apache.commons.logging.Log;
import software.amazon.kinesis.shaded.org.apache.commons.logging.LogFactory;

public class DefaultCWMetricsPublisher
implements ICWMetricsPublisher<CWMetricKey> {
    private static final Log LOG = LogFactory.getLog(CWPublisherRunnable.class);
    private static final int BATCH_SIZE = 20;
    private final String namespace;
    private final AmazonCloudWatch cloudWatchClient;

    public DefaultCWMetricsPublisher(AmazonCloudWatch cloudWatchClient, String namespace) {
        this.cloudWatchClient = cloudWatchClient;
        this.namespace = namespace;
    }

    @Override
    public void publishMetrics(List<MetricDatumWithKey<CWMetricKey>> dataToPublish) {
        for (int startIndex = 0; startIndex < dataToPublish.size(); startIndex += 20) {
            int endIndex = Math.min(dataToPublish.size(), startIndex + 20);
            PutMetricDataRequest request = new PutMetricDataRequest();
            request.setNamespace(this.namespace);
            ArrayList<MetricDatum> metricData = new ArrayList<MetricDatum>();
            for (int i = startIndex; i < endIndex; ++i) {
                metricData.add(dataToPublish.get((int)i).datum);
            }
            request.setMetricData(metricData);
            try {
                this.cloudWatchClient.putMetricData(request);
                LOG.debug(String.format("Successfully published %d datums.", endIndex - startIndex));
                continue;
            }
            catch (AmazonClientException e) {
                LOG.warn(String.format("Could not publish %d datums to CloudWatch", endIndex - startIndex), e);
            }
        }
    }
}

