/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import software.amazon.kinesis.shaded.com.amazonaws.util.json.Jackson;

public class Lease {
    private static final long MAX_ABS_AGE_NANOS = TimeUnit.DAYS.toNanos(365L);
    private String leaseKey;
    private String leaseOwner;
    private Long leaseCounter = 0L;
    private UUID concurrencyToken;
    private Long lastCounterIncrementNanos;

    public Lease() {
    }

    protected Lease(Lease lease) {
        this(lease.getLeaseKey(), lease.getLeaseOwner(), lease.getLeaseCounter(), lease.getConcurrencyToken(), lease.getLastCounterIncrementNanos());
    }

    protected Lease(String leaseKey, String leaseOwner, Long leaseCounter, UUID concurrencyToken, Long lastCounterIncrementNanos) {
        this.leaseKey = leaseKey;
        this.leaseOwner = leaseOwner;
        this.leaseCounter = leaseCounter;
        this.concurrencyToken = concurrencyToken;
        this.lastCounterIncrementNanos = lastCounterIncrementNanos;
    }

    public <T extends Lease> void update(T other) {
    }

    public String getLeaseKey() {
        return this.leaseKey;
    }

    public Long getLeaseCounter() {
        return this.leaseCounter;
    }

    public String getLeaseOwner() {
        return this.leaseOwner;
    }

    public UUID getConcurrencyToken() {
        return this.concurrencyToken;
    }

    public Long getLastCounterIncrementNanos() {
        return this.lastCounterIncrementNanos;
    }

    public boolean isExpired(long leaseDurationNanos, long asOfNanos) {
        if (this.lastCounterIncrementNanos == null) {
            return true;
        }
        long age = asOfNanos - this.lastCounterIncrementNanos;
        if (Math.abs(age) > MAX_ABS_AGE_NANOS) {
            return true;
        }
        return age > leaseDurationNanos;
    }

    public void setLastCounterIncrementNanos(Long lastCounterIncrementNanos) {
        this.lastCounterIncrementNanos = lastCounterIncrementNanos;
    }

    public void setConcurrencyToken(UUID concurrencyToken) {
        this.verifyNotNull(concurrencyToken, "concurencyToken cannot be null");
        this.concurrencyToken = concurrencyToken;
    }

    public void setLeaseKey(String leaseKey) {
        if (this.leaseKey != null) {
            throw new IllegalArgumentException("LeaseKey is immutable once set");
        }
        this.verifyNotNull(leaseKey, "LeaseKey cannot be set to null");
        this.leaseKey = leaseKey;
    }

    public void setLeaseCounter(Long leaseCounter) {
        this.verifyNotNull(leaseCounter, "leaseCounter must not be null");
        this.leaseCounter = leaseCounter;
    }

    public void setLeaseOwner(String leaseOwner) {
        this.leaseOwner = leaseOwner;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leaseCounter == null ? 0 : this.leaseCounter.hashCode());
        result = 31 * result + (this.leaseOwner == null ? 0 : this.leaseOwner.hashCode());
        result = 31 * result + (this.leaseKey == null ? 0 : this.leaseKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Lease other = (Lease)obj;
        if (this.leaseCounter == null ? other.leaseCounter != null : !this.leaseCounter.equals(other.leaseCounter)) {
            return false;
        }
        if (this.leaseOwner == null ? other.leaseOwner != null : !this.leaseOwner.equals(other.leaseOwner)) {
            return false;
        }
        return !(this.leaseKey == null ? other.leaseKey != null : !this.leaseKey.equals(other.leaseKey));
    }

    public String toString() {
        return Jackson.toJsonPrettyString(this);
    }

    public <T extends Lease> T copy() {
        return (T)new Lease(this);
    }

    private void verifyNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

