/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.HashKeyRangeForLease;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.Lease;

public class KinesisClientLease
extends Lease {
    private ExtendedSequenceNumber checkpoint;
    private ExtendedSequenceNumber pendingCheckpoint;
    private Long ownerSwitchesSinceCheckpoint = 0L;
    private Set<String> parentShardIds = new HashSet<String>();
    private Set<String> childShardIds = new HashSet<String>();
    private HashKeyRangeForLease hashKeyRangeForLease;

    public KinesisClientLease() {
    }

    public KinesisClientLease(KinesisClientLease other) {
        super(other);
        this.checkpoint = other.getCheckpoint();
        this.pendingCheckpoint = other.getPendingCheckpoint();
        this.ownerSwitchesSinceCheckpoint = other.getOwnerSwitchesSinceCheckpoint();
        this.parentShardIds.addAll(other.getParentShardIds());
        this.childShardIds.addAll(other.getChildShardIds());
        this.hashKeyRangeForLease = other.getHashKeyRange();
    }

    KinesisClientLease(String leaseKey, String leaseOwner, Long leaseCounter, UUID concurrencyToken, Long lastCounterIncrementNanos, ExtendedSequenceNumber checkpoint, ExtendedSequenceNumber pendingCheckpoint, Long ownerSwitchesSinceCheckpoint, Set<String> parentShardIds, Set<String> childShardIds, HashKeyRangeForLease hashKeyRangeForLease) {
        super(leaseKey, leaseOwner, leaseCounter, concurrencyToken, lastCounterIncrementNanos);
        this.checkpoint = checkpoint;
        this.pendingCheckpoint = pendingCheckpoint;
        this.ownerSwitchesSinceCheckpoint = ownerSwitchesSinceCheckpoint;
        this.parentShardIds.addAll(parentShardIds);
        this.childShardIds.addAll(childShardIds);
        this.hashKeyRangeForLease = hashKeyRangeForLease;
    }

    @Override
    public <T extends Lease> void update(T other) {
        super.update(other);
        if (!(other instanceof KinesisClientLease)) {
            throw new IllegalArgumentException("Must pass KinesisClientLease object to KinesisClientLease.update(Lease)");
        }
        KinesisClientLease casted = (KinesisClientLease)other;
        this.setOwnerSwitchesSinceCheckpoint(casted.ownerSwitchesSinceCheckpoint);
        this.setCheckpoint(casted.checkpoint);
        this.setPendingCheckpoint(casted.pendingCheckpoint);
        this.setParentShardIds(casted.parentShardIds);
        this.setChildShardIds(casted.childShardIds);
    }

    public ExtendedSequenceNumber getCheckpoint() {
        return this.checkpoint;
    }

    public ExtendedSequenceNumber getPendingCheckpoint() {
        return this.pendingCheckpoint;
    }

    public Long getOwnerSwitchesSinceCheckpoint() {
        return this.ownerSwitchesSinceCheckpoint;
    }

    public Set<String> getParentShardIds() {
        return new HashSet<String>(this.parentShardIds);
    }

    public Set<String> getChildShardIds() {
        return new HashSet<String>(this.childShardIds);
    }

    public HashKeyRangeForLease getHashKeyRange() {
        return this.hashKeyRangeForLease;
    }

    public void setCheckpoint(ExtendedSequenceNumber checkpoint) {
        this.verifyNotNull(checkpoint, "Checkpoint should not be null");
        this.checkpoint = checkpoint;
    }

    public void setPendingCheckpoint(ExtendedSequenceNumber pendingCheckpoint) {
        this.pendingCheckpoint = pendingCheckpoint;
    }

    public void setOwnerSwitchesSinceCheckpoint(Long ownerSwitchesSinceCheckpoint) {
        this.verifyNotNull(ownerSwitchesSinceCheckpoint, "ownerSwitchesSinceCheckpoint should not be null");
        this.ownerSwitchesSinceCheckpoint = ownerSwitchesSinceCheckpoint;
    }

    public void setParentShardIds(Collection<String> parentShardIds) {
        this.verifyNotNull(parentShardIds, "parentShardIds should not be null");
        this.parentShardIds.clear();
        this.parentShardIds.addAll(parentShardIds);
    }

    public void setChildShardIds(Collection<String> childShardIds) {
        this.childShardIds.addAll(childShardIds);
    }

    public void setHashKeyRange(HashKeyRangeForLease hashKeyRangeForLease) {
        this.verifyNotNull(hashKeyRangeForLease, "hashKeyRangeForLease should not be null");
        this.hashKeyRangeForLease = hashKeyRangeForLease;
    }

    private void verifyNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.checkpoint == null ? 0 : this.checkpoint.hashCode());
        result = this.pendingCheckpoint == null ? result : 31 * result + this.pendingCheckpoint.hashCode();
        result = 31 * result + (this.ownerSwitchesSinceCheckpoint == null ? 0 : this.ownerSwitchesSinceCheckpoint.hashCode());
        result = 31 * result + (this.parentShardIds == null ? 0 : this.parentShardIds.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KinesisClientLease other = (KinesisClientLease)obj;
        if (this.checkpoint == null ? other.checkpoint != null : !this.checkpoint.equals(other.checkpoint)) {
            return false;
        }
        if (this.pendingCheckpoint == null ? other.pendingCheckpoint != null : !this.pendingCheckpoint.equals(other.pendingCheckpoint)) {
            return false;
        }
        if (this.ownerSwitchesSinceCheckpoint == null ? other.ownerSwitchesSinceCheckpoint != null : !this.ownerSwitchesSinceCheckpoint.equals(other.ownerSwitchesSinceCheckpoint)) {
            return false;
        }
        return !(this.parentShardIds == null ? other.parentShardIds != null : !this.parentShardIds.equals(other.parentShardIds));
    }

    @Override
    public <T extends Lease> T copy() {
        return (T)new KinesisClientLease(this);
    }
}

