/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.concurrent.CountDownLatch;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownNotification;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.LeaseCoordinator;

class ShardConsumerShutdownNotification
implements ShutdownNotification {
    private final LeaseCoordinator<KinesisClientLease> leaseCoordinator;
    private final KinesisClientLease lease;
    private final CountDownLatch shutdownCompleteLatch;
    private final CountDownLatch notificationCompleteLatch;
    private boolean notificationComplete = false;
    private boolean allNotificationCompleted = false;

    ShardConsumerShutdownNotification(LeaseCoordinator<KinesisClientLease> leaseCoordinator, KinesisClientLease lease, CountDownLatch notificationCompleteLatch, CountDownLatch shutdownCompleteLatch) {
        this.leaseCoordinator = leaseCoordinator;
        this.lease = lease;
        this.notificationCompleteLatch = notificationCompleteLatch;
        this.shutdownCompleteLatch = shutdownCompleteLatch;
    }

    @Override
    public void shutdownNotificationComplete() {
        if (this.notificationComplete) {
            return;
        }
        this.leaseCoordinator.dropLease(this.lease);
        this.notificationCompleteLatch.countDown();
        this.notificationComplete = true;
    }

    @Override
    public void shutdownComplete() {
        if (this.allNotificationCompleted) {
            return;
        }
        if (!this.notificationComplete) {
            this.notificationCompleteLatch.countDown();
        }
        this.shutdownCompleteLatch.countDown();
        this.allNotificationCompleted = true;
    }
}

