/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisShardSyncer;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaseSynchronizer;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.Lease;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import software.amazon.kinesis.shaded.org.apache.commons.logging.Log;
import software.amazon.kinesis.shaded.org.apache.commons.logging.LogFactory;

class NonEmptyLeaseTableSynchronizer
implements LeaseSynchronizer {
    private static final Log LOG = LogFactory.getLog(NonEmptyLeaseTableSynchronizer.class);
    private final Map<String, Shard> shardIdToShardMap;
    private final Map<String, Set<String>> shardIdToChildShardIdsMap;

    @Override
    public List<KinesisClientLease> determineNewLeasesToCreate(List<Shard> shards, List<KinesisClientLease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds) {
        HashMap<String, KinesisClientLease> shardIdToNewLeaseMap = new HashMap<String, KinesisClientLease>();
        Map<String, Shard> shardIdToShardMapOfAllKinesisShards = KinesisShardSyncer.constructShardIdToShardMap(shards);
        HashSet<String> shardIdsOfCurrentLeases = new HashSet<String>();
        for (Lease lease : currentLeases) {
            shardIdsOfCurrentLeases.add(lease.getLeaseKey());
            LOG.debug("Existing lease: " + lease);
        }
        List<Shard> openShards = KinesisShardSyncer.getOpenShards(shards);
        KinesisShardSyncer.MemoizationContext memoizationContext = new KinesisShardSyncer.MemoizationContext();
        for (Shard shard : openShards) {
            String shardId = shard.getShardId();
            LOG.debug("Evaluating leases for open shard " + shardId + " and its ancestors.");
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                LOG.debug("Lease for shardId " + shardId + " already exists. Not creating a lease");
                continue;
            }
            if (inconsistentShardIds.contains(shardId)) {
                LOG.info("shardId " + shardId + " is an inconsistent child.  Not creating a lease");
                continue;
            }
            LOG.debug("Beginning traversal of ancestry tree for shardId " + shardId);
            boolean isDescendant = KinesisShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(shardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToNewLeaseMap, memoizationContext);
            if (!isDescendant) {
                LOG.debug("ShardId " + shardId + " has no ancestors. Creating a lease.");
                KinesisClientLease newLease = KinesisShardSyncer.newKCLLease(shard);
                newLease.setCheckpoint(KinesisShardSyncer.convertToCheckpoint(initialPosition));
                LOG.debug("Set checkpoint of " + newLease.getLeaseKey() + " to " + newLease.getCheckpoint());
                shardIdToNewLeaseMap.put(shardId, newLease);
                continue;
            }
            LOG.debug("ShardId " + shardId + " is a descendant whose ancestors should already have leases. Not creating a lease.");
        }
        ArrayList<KinesisClientLease> newLeasesToCreate = new ArrayList<KinesisClientLease>();
        newLeasesToCreate.addAll(shardIdToNewLeaseMap.values());
        KinesisShardSyncer.StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new KinesisShardSyncer.StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards);
        Collections.sort(newLeasesToCreate, startingSequenceNumberComparator);
        return newLeasesToCreate;
    }

    public NonEmptyLeaseTableSynchronizer(Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap) {
        this.shardIdToShardMap = shardIdToShardMap;
        this.shardIdToChildShardIdsMap = shardIdToChildShardIdsMap;
    }
}

