/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec;

import software.amazon.kinesis.shaded.com.amazonaws.annotation.Beta;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.Condition;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.Operand;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.PathOperand;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.Precedence;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;

@Beta
public final class FunctionCondition
extends Condition {
    private final String functionId;
    private final PathOperand pathOperand;
    private final Operand operand;

    FunctionCondition(String functionId, PathOperand attribute) {
        this.functionId = functionId;
        this.pathOperand = attribute;
        this.operand = null;
    }

    FunctionCondition(String functionId, PathOperand attribute, Operand operand) {
        this.functionId = functionId;
        this.pathOperand = attribute;
        this.operand = operand;
    }

    @Override
    String asSubstituted(SubstitutionContext context) {
        StringBuilder sb = new StringBuilder(this.functionId).append("(").append(this.pathOperand.asSubstituted(context));
        if (this.operand != null) {
            sb.append(", ").append(this.operand.asSubstituted(context));
        }
        return sb.append(")").toString();
    }

    String getFunctionId() {
        return this.functionId;
    }

    PathOperand getPathOperand() {
        return this.pathOperand;
    }

    Operand getOperand() {
        return this.operand;
    }

    @Override
    boolean atomic() {
        return true;
    }

    @Override
    int precedence() {
        return Precedence.Function.value();
    }
}

