/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters;

import java.util.concurrent.ExecutorService;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters.DescribeTableFunction;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters.TableExists;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters.TableNotExists;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.PollingStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.Waiter;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterExecutorServiceFactory;

public class AmazonDynamoDBWaiters {
    private final AmazonDynamoDB client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonDynamoDBWaiters");

    @SdkInternalApi
    public AmazonDynamoDBWaiters(AmazonDynamoDB client) {
        this.client = client;
    }

    public Waiter<DescribeTableRequest> tableExists() {
        return new WaiterBuilder<DescribeTableRequest, DescribeTableResult>().withSdkFunction(new DescribeTableFunction(this.client)).withAcceptors(new TableExists.IsACTIVEMatcher(), new TableExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTableRequest> tableNotExists() {
        return new WaiterBuilder<DescribeTableRequest, DescribeTableResult>().withSdkFunction(new DescribeTableFunction(this.client)).withAcceptors(new TableNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

