/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter;

import java.util.concurrent.ExecutorService;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.client.builder.AwsClientBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.regions.Regions;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsProxy;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsShardSyncer;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.StreamsDeterministicShuffleShardSyncLeaderDecider;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.StreamsLeaseCleanupValidator;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.leases.StreamsLeaseTaker;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLeaseManager;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;
import software.amazon.kinesis.shaded.org.apache.commons.logging.Log;
import software.amazon.kinesis.shaded.org.apache.commons.logging.LogFactory;

public class StreamsWorkerFactory {
    private static final Log LOG = LogFactory.getLog(StreamsWorkerFactory.class);

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, ExecutorService execService) {
        AmazonDynamoDBStreamsAdapterClient streamsClient = new AmazonDynamoDBStreamsAdapterClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration());
        AmazonDynamoDB dynamoDBClient = (AmazonDynamoDB)StreamsWorkerFactory.createClient(AmazonDynamoDBClientBuilder.standard(), config.getDynamoDBCredentialsProvider(), config.getDynamoDBClientConfiguration(), config.getDynamoDBEndpoint(), config.getRegionName());
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient, config.getBillingMode());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardSyncer(new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator())).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager(kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker<KinesisClientLease>(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider(new StreamsDeterministicShuffleShardSyncLeaderDecider(config, kinesisClientLeaseManager)).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient, config.getBillingMode());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardSyncer(new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator())).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager(kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker<KinesisClientLease>(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider(new StreamsDeterministicShuffleShardSyncLeaderDecider(config, kinesisClientLeaseManager)).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient, ExecutorService execService) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient, config.getBillingMode());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardSyncer(new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator())).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager(kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker<KinesisClientLease>(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider(new StreamsDeterministicShuffleShardSyncLeaderDecider(config, kinesisClientLeaseManager)).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient, config.getBillingMode());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).metricsFactory(metricsFactory).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardSyncer(new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator())).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager(kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker<KinesisClientLease>(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider(new StreamsDeterministicShuffleShardSyncLeaderDecider(config, kinesisClientLeaseManager)).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), (AmazonDynamoDB)dynamoDBClient, config.getBillingMode());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardSyncer(new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator())).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager(kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker<KinesisClientLease>(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider(new StreamsDeterministicShuffleShardSyncLeaderDecider(config, kinesisClientLeaseManager)).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient, ExecutorService execService) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), (AmazonDynamoDB)dynamoDBClient, config.getBillingMode());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardSyncer(new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator())).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager(kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker<KinesisClientLease>(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider(new StreamsDeterministicShuffleShardSyncLeaderDecider(config, kinesisClientLeaseManager)).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        KinesisClientLeaseManager kinesisClientLeaseManager = new KinesisClientLeaseManager(config.getTableName(), (AmazonDynamoDB)dynamoDBClient, config.getBillingMode());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).metricsFactory(metricsFactory).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardSyncer(new DynamoDBStreamsShardSyncer(new StreamsLeaseCleanupValidator())).shardPrioritization(config.getShardPrioritizationStrategy()).leaseManager(kinesisClientLeaseManager).leaseTaker(new StreamsLeaseTaker<KinesisClientLease>(kinesisClientLeaseManager, config.getWorkerIdentifier(), config.getFailoverTimeMillis()).maxLeasesForWorker(config.getMaxLeasesForWorker())).leaderDecider(new StreamsDeterministicShuffleShardSyncLeaderDecider(config, kinesisClientLeaseManager)).build();
    }

    private static DynamoDBStreamsProxy getDynamoDBStreamsProxy(KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient) {
        return new DynamoDBStreamsProxy.Builder(config.getStreamName(), config.getKinesisCredentialsProvider(), streamsClient).build();
    }

    private static <R, T extends AwsClientBuilder<T, R>> R createClient(T builder, AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, String endpointUrl, String region) {
        if (credentialsProvider != null) {
            builder.withCredentials(credentialsProvider);
        }
        if (clientConfiguration != null) {
            builder.withClientConfiguration(clientConfiguration);
        }
        if (!StringUtils.isNullOrEmpty(endpointUrl)) {
            LOG.warn("Received configuration for endpoint as " + endpointUrl + ", and region as " + region + ".");
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpointUrl, region));
        } else if (!StringUtils.isNullOrEmpty(region)) {
            LOG.warn("Received configuration for region as " + region + ".");
            builder.withRegion(region);
        } else {
            LOG.warn("No configuration received for endpoint and region, will default region to us-east-1");
            builder.withRegion(Regions.US_EAST_1);
        }
        return builder.build();
    }
}

