/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.StreamsWorkerFactory;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.multilang.MultiLangDaemon;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.multilang.MultiLangDaemonConfig;
import software.amazon.kinesis.shaded.org.apache.commons.logging.Log;
import software.amazon.kinesis.shaded.org.apache.commons.logging.LogFactory;

public class StreamsMultiLangDaemon {
    private static final Log LOG = LogFactory.getLog(StreamsMultiLangDaemon.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            MultiLangDaemon.printUsage(System.err, "You must provide a properties file");
            System.exit(1);
        }
        MultiLangDaemonConfig config = null;
        try {
            config = new MultiLangDaemonConfig(args[0]);
        }
        catch (IOException | IllegalArgumentException e) {
            MultiLangDaemon.printUsage(System.err, "You must provide a valid properties file");
            System.exit(1);
        }
        ExecutorService executorService = config.getExecutorService();
        Worker worker = StreamsWorkerFactory.createDynamoDbStreamsWorker(config.getRecordProcessorFactory(), config.getKinesisClientLibConfiguration(), executorService);
        MultiLangDaemon daemon = new MultiLangDaemon(worker);
        Future<Integer> future = executorService.submit(daemon);
        try {
            System.exit(future.get());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Encountered an error while running daemon", e);
        }
        System.exit(1);
    }
}

