/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import java.util.Date;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TableClassSummary;

@SdkInternalApi
public class TableClassSummaryMarshaller {
    private static final MarshallingInfo<String> TABLECLASS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableClass").build();
    private static final MarshallingInfo<Date> LASTUPDATEDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateDateTime").timestampFormat("unixTimestamp").build();
    private static final TableClassSummaryMarshaller instance = new TableClassSummaryMarshaller();

    public static TableClassSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableClassSummary tableClassSummary, ProtocolMarshaller protocolMarshaller) {
        if (tableClassSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tableClassSummary.getTableClass(), TABLECLASS_BINDING);
            protocolMarshaller.marshall(tableClassSummary.getLastUpdateDateTime(), LASTUPDATEDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

