/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import java.util.Date;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ArchivalSummary;

@SdkInternalApi
public class ArchivalSummaryMarshaller {
    private static final MarshallingInfo<Date> ARCHIVALDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchivalDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ARCHIVALREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchivalReason").build();
    private static final MarshallingInfo<String> ARCHIVALBACKUPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchivalBackupArn").build();
    private static final ArchivalSummaryMarshaller instance = new ArchivalSummaryMarshaller();

    public static ArchivalSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ArchivalSummary archivalSummary, ProtocolMarshaller protocolMarshaller) {
        if (archivalSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(archivalSummary.getArchivalDateTime(), ARCHIVALDATETIME_BINDING);
            protocolMarshaller.marshall(archivalSummary.getArchivalReason(), ARCHIVALREASON_BINDING);
            protocolMarshaller.marshall(archivalSummary.getArchivalBackupArn(), ARCHIVALBACKUPARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

