/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.BillingMode;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ReplicationGroupUpdate;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.SSESpecification;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TableClass;

public class UpdateTableRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<AttributeDefinition> attributeDefinitions;
    private String tableName;
    private String billingMode;
    private ProvisionedThroughput provisionedThroughput;
    private List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;
    private StreamSpecification streamSpecification;
    private SSESpecification sSESpecification;
    private List<ReplicationGroupUpdate> replicaUpdates;
    private String tableClass;

    public UpdateTableRequest() {
    }

    public UpdateTableRequest(String tableName, ProvisionedThroughput provisionedThroughput) {
        this.setTableName(tableName);
        this.setProvisionedThroughput(provisionedThroughput);
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null) {
            this.attributeDefinitions = null;
            return;
        }
        this.attributeDefinitions = new ArrayList<AttributeDefinition>(attributeDefinitions);
    }

    public UpdateTableRequest withAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
        if (this.attributeDefinitions == null) {
            this.setAttributeDefinitions(new ArrayList<AttributeDefinition>(attributeDefinitions.length));
        }
        for (AttributeDefinition ele : attributeDefinitions) {
            this.attributeDefinitions.add(ele);
        }
        return this;
    }

    public UpdateTableRequest withAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        this.setAttributeDefinitions(attributeDefinitions);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public UpdateTableRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public void setBillingMode(String billingMode) {
        this.billingMode = billingMode;
    }

    public String getBillingMode() {
        return this.billingMode;
    }

    public UpdateTableRequest withBillingMode(String billingMode) {
        this.setBillingMode(billingMode);
        return this;
    }

    public UpdateTableRequest withBillingMode(BillingMode billingMode) {
        this.billingMode = billingMode.toString();
        return this;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public UpdateTableRequest withProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.setProvisionedThroughput(provisionedThroughput);
        return this;
    }

    public List<GlobalSecondaryIndexUpdate> getGlobalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates;
    }

    public void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
        if (globalSecondaryIndexUpdates == null) {
            this.globalSecondaryIndexUpdates = null;
            return;
        }
        this.globalSecondaryIndexUpdates = new ArrayList<GlobalSecondaryIndexUpdate>(globalSecondaryIndexUpdates);
    }

    public UpdateTableRequest withGlobalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... globalSecondaryIndexUpdates) {
        if (this.globalSecondaryIndexUpdates == null) {
            this.setGlobalSecondaryIndexUpdates(new ArrayList<GlobalSecondaryIndexUpdate>(globalSecondaryIndexUpdates.length));
        }
        for (GlobalSecondaryIndexUpdate ele : globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates.add(ele);
        }
        return this;
    }

    public UpdateTableRequest withGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
        this.setGlobalSecondaryIndexUpdates(globalSecondaryIndexUpdates);
        return this;
    }

    public void setStreamSpecification(StreamSpecification streamSpecification) {
        this.streamSpecification = streamSpecification;
    }

    public StreamSpecification getStreamSpecification() {
        return this.streamSpecification;
    }

    public UpdateTableRequest withStreamSpecification(StreamSpecification streamSpecification) {
        this.setStreamSpecification(streamSpecification);
        return this;
    }

    public void setSSESpecification(SSESpecification sSESpecification) {
        this.sSESpecification = sSESpecification;
    }

    public SSESpecification getSSESpecification() {
        return this.sSESpecification;
    }

    public UpdateTableRequest withSSESpecification(SSESpecification sSESpecification) {
        this.setSSESpecification(sSESpecification);
        return this;
    }

    public List<ReplicationGroupUpdate> getReplicaUpdates() {
        return this.replicaUpdates;
    }

    public void setReplicaUpdates(Collection<ReplicationGroupUpdate> replicaUpdates) {
        if (replicaUpdates == null) {
            this.replicaUpdates = null;
            return;
        }
        this.replicaUpdates = new ArrayList<ReplicationGroupUpdate>(replicaUpdates);
    }

    public UpdateTableRequest withReplicaUpdates(ReplicationGroupUpdate ... replicaUpdates) {
        if (this.replicaUpdates == null) {
            this.setReplicaUpdates(new ArrayList<ReplicationGroupUpdate>(replicaUpdates.length));
        }
        for (ReplicationGroupUpdate ele : replicaUpdates) {
            this.replicaUpdates.add(ele);
        }
        return this;
    }

    public UpdateTableRequest withReplicaUpdates(Collection<ReplicationGroupUpdate> replicaUpdates) {
        this.setReplicaUpdates(replicaUpdates);
        return this;
    }

    public void setTableClass(String tableClass) {
        this.tableClass = tableClass;
    }

    public String getTableClass() {
        return this.tableClass;
    }

    public UpdateTableRequest withTableClass(String tableClass) {
        this.setTableClass(tableClass);
        return this;
    }

    public UpdateTableRequest withTableClass(TableClass tableClass) {
        this.tableClass = tableClass.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(this.getAttributeDefinitions()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getBillingMode() != null) {
            sb.append("BillingMode: ").append(this.getBillingMode()).append(",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.getProvisionedThroughput()).append(",");
        }
        if (this.getGlobalSecondaryIndexUpdates() != null) {
            sb.append("GlobalSecondaryIndexUpdates: ").append(this.getGlobalSecondaryIndexUpdates()).append(",");
        }
        if (this.getStreamSpecification() != null) {
            sb.append("StreamSpecification: ").append(this.getStreamSpecification()).append(",");
        }
        if (this.getSSESpecification() != null) {
            sb.append("SSESpecification: ").append(this.getSSESpecification()).append(",");
        }
        if (this.getReplicaUpdates() != null) {
            sb.append("ReplicaUpdates: ").append(this.getReplicaUpdates()).append(",");
        }
        if (this.getTableClass() != null) {
            sb.append("TableClass: ").append(this.getTableClass());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)obj;
        if (other.getAttributeDefinitions() == null ^ this.getAttributeDefinitions() == null) {
            return false;
        }
        if (other.getAttributeDefinitions() != null && !other.getAttributeDefinitions().equals(this.getAttributeDefinitions())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getBillingMode() == null ^ this.getBillingMode() == null) {
            return false;
        }
        if (other.getBillingMode() != null && !other.getBillingMode().equals(this.getBillingMode())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (other.getProvisionedThroughput() != null && !other.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (other.getGlobalSecondaryIndexUpdates() == null ^ this.getGlobalSecondaryIndexUpdates() == null) {
            return false;
        }
        if (other.getGlobalSecondaryIndexUpdates() != null && !other.getGlobalSecondaryIndexUpdates().equals(this.getGlobalSecondaryIndexUpdates())) {
            return false;
        }
        if (other.getStreamSpecification() == null ^ this.getStreamSpecification() == null) {
            return false;
        }
        if (other.getStreamSpecification() != null && !other.getStreamSpecification().equals(this.getStreamSpecification())) {
            return false;
        }
        if (other.getSSESpecification() == null ^ this.getSSESpecification() == null) {
            return false;
        }
        if (other.getSSESpecification() != null && !other.getSSESpecification().equals(this.getSSESpecification())) {
            return false;
        }
        if (other.getReplicaUpdates() == null ^ this.getReplicaUpdates() == null) {
            return false;
        }
        if (other.getReplicaUpdates() != null && !other.getReplicaUpdates().equals(this.getReplicaUpdates())) {
            return false;
        }
        if (other.getTableClass() == null ^ this.getTableClass() == null) {
            return false;
        }
        return other.getTableClass() == null || other.getTableClass().equals(this.getTableClass());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeDefinitions() == null ? 0 : this.getAttributeDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getBillingMode() == null ? 0 : this.getBillingMode().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalSecondaryIndexUpdates() == null ? 0 : this.getGlobalSecondaryIndexUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getStreamSpecification() == null ? 0 : this.getStreamSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getSSESpecification() == null ? 0 : this.getSSESpecification().hashCode());
        hashCode = 31 * hashCode + (this.getReplicaUpdates() == null ? 0 : this.getReplicaUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getTableClass() == null ? 0 : this.getTableClass().hashCode());
        return hashCode;
    }

    @Override
    public UpdateTableRequest clone() {
        return (UpdateTableRequest)super.clone();
    }
}

