/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.BatchStatementRequestMarshaller;

public class BatchStatementRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String statement;
    private List<AttributeValue> parameters;
    private Boolean consistentRead;

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public String getStatement() {
        return this.statement;
    }

    public BatchStatementRequest withStatement(String statement) {
        this.setStatement(statement);
        return this;
    }

    public List<AttributeValue> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<AttributeValue> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<AttributeValue>(parameters);
    }

    public BatchStatementRequest withParameters(AttributeValue ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<AttributeValue>(parameters.length));
        }
        for (AttributeValue ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public BatchStatementRequest withParameters(Collection<AttributeValue> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public BatchStatementRequest withConsistentRead(Boolean consistentRead) {
        this.setConsistentRead(consistentRead);
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatement() != null) {
            sb.append("Statement: ").append(this.getStatement()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getConsistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.getConsistentRead());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStatementRequest)) {
            return false;
        }
        BatchStatementRequest other = (BatchStatementRequest)obj;
        if (other.getStatement() == null ^ this.getStatement() == null) {
            return false;
        }
        if (other.getStatement() != null && !other.getStatement().equals(this.getStatement())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getConsistentRead() == null ^ this.getConsistentRead() == null) {
            return false;
        }
        return other.getConsistentRead() == null || other.getConsistentRead().equals(this.getConsistentRead());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatement() == null ? 0 : this.getStatement().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getConsistentRead() == null ? 0 : this.getConsistentRead().hashCode());
        return hashCode;
    }

    public BatchStatementRequest clone() {
        try {
            return (BatchStatementRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchStatementRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

