/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.Collection;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Expected;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.UpdateItemOutcome;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.UpdateItemApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.UpdateItemSpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;

public class UpdateItemImpl
implements UpdateItemApi {
    private final Table table;
    private final AmazonDynamoDB client;

    public UpdateItemImpl(AmazonDynamoDB client, Table table) {
        this.client = client;
        this.table = table;
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new UpdateItemSpec().withPrimaryKey(primaryKey).withAttributeUpdate(attributeUpdates));
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new UpdateItemSpec().withPrimaryKey(primaryKey).withExpected(expected).withAttributeUpdate(attributeUpdates));
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new UpdateItemSpec().withPrimaryKey(primaryKey).withUpdateExpression(updateExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new UpdateItemSpec().withPrimaryKey(primaryKey).withUpdateExpression(updateExpression).withConditionExpression(conditionExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public UpdateItemOutcome updateItem(UpdateItemSpec spec) {
        return this.doUpdateItem(spec);
    }

    private UpdateItemOutcome doUpdateItem(UpdateItemSpec spec) {
        UpdateItemRequest request = (UpdateItemRequest)spec.getRequest();
        request.setKey(InternalUtils.toAttributeValueMap(spec.getKeyComponents()));
        request.setTableName(this.table.getTableName());
        Collection<Expected> expected = spec.getExpected();
        Map<String, ExpectedAttributeValue> expectedMap = InternalUtils.toExpectedAttributeValueMap(expected);
        request.setExpected(expectedMap);
        request.setAttributeUpdates(InternalUtils.toAttributeValueUpdate(spec.getAttributeUpdate()));
        request.setExpressionAttributeNames(spec.getNameMap());
        request.setExpressionAttributeValues(InternalUtils.fromSimpleMap(spec.getValueMap()));
        return new UpdateItemOutcome(this.client.updateItem(request));
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue), attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue), expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue), updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue), updateExpression, conditionExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), updateExpression, conditionExpression, nameMap, valueMap);
    }
}

